/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class NonSymmetricEquals
extends BytecodeScanningDetector {
    private BugReporter bugReporter;
    private OpcodeStack stack;
    private Map<String, Map<String, BugInstance>> possibleBugs = new HashMap<String, Map<String, BugInstance>>();

    public NonSymmetricEquals(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        try {
            this.stack = new OpcodeStack();
            super.visitClassContext(classContext);
            Object var3_2 = null;
            this.stack = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.stack = null;
            throw throwable;
        }
    }

    public void visitCode(Code obj) {
        Method m = this.getMethod();
        String name = m.getName();
        String signature = m.getSignature();
        if ("equals".equals(name) && "(Ljava/lang/Object;)Z".equals(signature) && this.prescreen(m)) {
            this.stack.resetForMethodEntry((DismantleBytecode)this);
            super.visitCode(obj);
        }
    }

    public boolean prescreen(Method method) {
        BitSet bytecodeSet = this.getClassContext().getBytecodeSet(method);
        return bytecodeSet != null && bytecodeSet.get(192);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sawOpcode(int seen) {
        try {
            block5: {
                try {
                    JavaClass equalsJavaClass;
                    String equalsCls;
                    String thisCls;
                    OpcodeStack.Item item;
                    this.stack.precomputation((DismantleBytecode)this);
                    if (seen != 192 || this.stack.getStackDepth() <= 0 || (item = this.stack.getStackItem(0)).getRegisterNumber() != 1 || (thisCls = this.getClassName()).equals(equalsCls = this.getClassConstantOperand())) break block5;
                    JavaClass thisJavaClass = this.getClassContext().getJavaClass();
                    boolean inheritance = thisJavaClass.instanceOf(equalsJavaClass = Repository.lookupClass((String)equalsCls)) || equalsJavaClass.instanceOf(thisJavaClass);
                    BugInstance bug = new BugInstance((Detector)this, "NSE_NON_SYMMETRIC_EQUALS", inheritance ? 3 : 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this).addString(equalsCls);
                    Map<String, BugInstance> bugs = this.possibleBugs.get(thisCls);
                    if (bugs == null) {
                        bugs = new HashMap<String, BugInstance>();
                        this.possibleBugs.put(thisCls, bugs);
                    }
                    bugs.put(equalsCls, bug);
                }
                catch (ClassNotFoundException cnfe) {
                    this.bugReporter.reportMissingClass(cnfe);
                    Object var11_12 = null;
                    this.stack.sawOpcode((DismantleBytecode)this, seen);
                    return;
                }
            }
            Object var11_11 = null;
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            return;
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            throw throwable;
        }
    }

    public void report() {
        block0: for (Map.Entry<String, Map<String, BugInstance>> thisEntry : this.possibleBugs.entrySet()) {
            Map<String, BugInstance> equalsClassesMap = thisEntry.getValue();
            for (Map.Entry<String, BugInstance> equalsEntry : equalsClassesMap.entrySet()) {
                String equalsCls = equalsEntry.getKey();
                Map<String, BugInstance> reverseEqualsClassMap = this.possibleBugs.get(equalsCls);
                if (reverseEqualsClassMap == null) {
                    this.bugReporter.reportBug(equalsClassesMap.values().iterator().next());
                    continue block0;
                }
                if (reverseEqualsClassMap.containsKey(thisEntry.getKey())) continue;
                this.bugReporter.reportBug(equalsClassesMap.values().iterator().next());
                continue block0;
            }
        }
        this.possibleBugs.clear();
    }
}

