/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartiallyConstructedObjectAccess
extends BytecodeScanningDetector {
    private final BugReporter bugReporter;
    private OpcodeStack stack;
    private Map<Method, Map<Method, SourceLineAnnotation>> methodToCalledMethods;
    private boolean reportedCtor;
    private boolean isCtor;

    public PartiallyConstructedObjectAccess(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        try {
            JavaClass cls = classContext.getJavaClass();
            if ((cls.getAccessFlags() & 0x10) == 0) {
                this.stack = new OpcodeStack();
                this.methodToCalledMethods = new HashMap<Method, Map<Method, SourceLineAnnotation>>();
                super.visitClassContext(classContext);
                if (this.methodToCalledMethods.size() > 0) {
                    this.reportChainedMethods();
                }
            }
            Object var4_3 = null;
            this.stack = null;
            this.methodToCalledMethods = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.stack = null;
            this.methodToCalledMethods = null;
            throw throwable;
        }
    }

    public void visitCode(Code obj) {
        this.stack.resetForMethodEntry((DismantleBytecode)this);
        String methodName = this.getMethodName();
        this.isCtor = "<init>".equals(methodName);
        if (!"<clinit>".equals(methodName)) {
            Method m = this.getMethod();
            this.methodToCalledMethods.put(m, new HashMap());
            this.reportedCtor = false;
            super.visitCode(obj);
            if (this.reportedCtor || this.methodToCalledMethods.get(m).isEmpty()) {
                this.methodToCalledMethods.remove(this.getMethod());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sawOpcode(int seen) {
        if (this.reportedCtor) {
            return;
        }
        try {
            block6: {
                try {
                    Method m;
                    JavaClass cls;
                    OpcodeStack.Item itm;
                    this.stack.precomputation((DismantleBytecode)this);
                    if (seen != 182 && seen != 185 && seen != 183) break block6;
                    int parmCount = Type.getArgumentTypes((String)this.getSigConstantOperand()).length;
                    if (this.stack.getStackDepth() <= parmCount || (itm = this.stack.getStackItem(parmCount)).getRegisterNumber() != 0 || (cls = itm.getJavaClass()) == null || (m = this.findMethod(cls, this.getNameConstantOperand(), this.getSigConstantOperand())) == null || (m.getAccessFlags() & 0x10) != 0) break block6;
                    if (this.isCtor && seen != 183) {
                        this.bugReporter.reportBug(new BugInstance((Detector)this, "PCOA_PARTIALLY_CONSTRUCTED_OBJECT_ACCESS", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this, this.getPC()));
                        this.reportedCtor = true;
                        break block6;
                    }
                    if ("<init>".equals(m.getName())) break block6;
                    Map<Method, SourceLineAnnotation> calledMethods = this.methodToCalledMethods.get(this.getMethod());
                    calledMethods.put(m, SourceLineAnnotation.fromVisitedInstruction((BytecodeScanningDetector)this));
                }
                catch (ClassNotFoundException cnfe) {
                    this.bugReporter.reportMissingClass(cnfe);
                    Object var8_9 = null;
                    this.stack.sawOpcode((DismantleBytecode)this, seen);
                    return;
                }
            }
            Object var8_8 = null;
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            return;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            throw throwable;
        }
    }

    private Method findMethod(JavaClass cls, String methodName, String methodSig) {
        Method[] methods;
        for (Method m : methods = cls.getMethods()) {
            if (!methodName.equals(m.getName()) || !methodSig.equals(m.getSignature())) continue;
            return m;
        }
        return null;
    }

    private void reportChainedMethods() {
        HashSet<Method> checkedMethods = new HashSet<Method>();
        JavaClass cls = this.getClassContext().getJavaClass();
        for (Map.Entry<Method, Map<Method, SourceLineAnnotation>> entry : this.methodToCalledMethods.entrySet()) {
            Method m = entry.getKey();
            if (!"<init>".equals(m.getName())) continue;
            checkedMethods.clear();
            List<SourceLineAnnotation> slas = this.foundPrivateInChain(m, checkedMethods);
            if (slas == null) continue;
            BugInstance bi = new BugInstance((Detector)this, "PCOA_PARTIALLY_CONSTRUCTED_OBJECT_ACCESS", 3).addClass(cls).addMethod(cls, m);
            for (SourceLineAnnotation sla : slas) {
                bi.addSourceLine(sla);
            }
            this.bugReporter.reportBug(bi);
        }
    }

    private List<SourceLineAnnotation> foundPrivateInChain(Method m, Set<Method> checkedMethods) {
        Map<Method, SourceLineAnnotation> calledMethods = this.methodToCalledMethods.get(m);
        if (calledMethods != null) {
            for (Map.Entry<Method, SourceLineAnnotation> entry : calledMethods.entrySet()) {
                List<Object> slas;
                Method cm = entry.getKey();
                if (checkedMethods.contains(cm)) continue;
                if (!cm.isPrivate() && (cm.getAccessFlags() & 0x10) == 0) {
                    slas = new LinkedList();
                    slas.add(entry.getValue());
                    return slas;
                }
                checkedMethods.add(cm);
                slas = this.foundPrivateInChain(cm, checkedMethods);
                if (slas == null) continue;
                slas.add(0, entry.getValue());
                return slas;
            }
        }
        return null;
    }
}

