/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.Type;

public class PossibleMemoryBloat
extends BytecodeScanningDetector {
    private static final Set<String> bloatableSigs = new HashSet<String>();
    private static final Set<String> decreasingMethods;
    private static final Set<String> increasingMethods;
    private final BugReporter bugReporter;
    private Map<XField, SourceLineAnnotation> bloatableFields;
    private OpcodeStack stack;
    private String methodName;

    public PossibleMemoryBloat(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        try {
            Field[] fields;
            this.bloatableFields = new HashMap<XField, SourceLineAnnotation>();
            JavaClass cls = classContext.getJavaClass();
            for (Field f : fields = cls.getFields()) {
                String sig;
                if (!f.isStatic() || !bloatableSigs.contains(sig = f.getSignature())) continue;
                this.bloatableFields.put(XFactory.createXField((String)cls.getClassName(), (String)f.getName(), (String)f.getSignature(), (boolean)f.isStatic()), null);
            }
            if (this.bloatableFields.size() > 0) {
                this.stack = new OpcodeStack();
                super.visitClassContext(classContext);
                for (Map.Entry<XField, SourceLineAnnotation> entry : this.bloatableFields.entrySet()) {
                    SourceLineAnnotation sla = entry.getValue();
                    if (sla == null) continue;
                    this.bugReporter.reportBug(new BugInstance((Detector)this, "PMB_POSSIBLE_MEMORY_BLOAT", 2).addClass((PreorderVisitor)this).addSourceLine(sla).addField(entry.getKey()));
                }
            }
            Object var10_11 = null;
            this.stack = null;
            this.bloatableFields = null;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            this.stack = null;
            this.bloatableFields = null;
            throw throwable;
        }
    }

    public void visitMethod(Method obj) {
        this.methodName = obj.getName();
    }

    public void visitCode(Code obj) {
        this.stack.resetForMethodEntry((DismantleBytecode)this);
        if ("<clinit>".equals(this.methodName) || "<init>".equals(this.methodName)) {
            return;
        }
        if (this.bloatableFields.size() > 0) {
            super.visitCode(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sawOpcode(int seen) {
        block8: {
            block7: {
                try {
                    OpcodeStack.Item returnItem;
                    XField field;
                    if (this.bloatableFields.isEmpty()) {
                        Object var9_2 = null;
                        break block7;
                    }
                    this.stack.precomputation((DismantleBytecode)this);
                    if (seen == 182 || seen == 185) {
                        OpcodeStack.Item itm;
                        XField field2;
                        String sig = this.getSigConstantOperand();
                        int argCount = Type.getArgumentTypes((String)sig).length;
                        if (this.stack.getStackDepth() <= argCount || (field2 = (itm = this.stack.getStackItem(argCount)).getXField()) == null || !this.bloatableFields.containsKey(field2)) break block8;
                        String mName = this.getNameConstantOperand();
                        if (decreasingMethods.contains(mName)) {
                            this.bloatableFields.remove(field2);
                            break block8;
                        }
                        if (increasingMethods.contains(mName) && this.bloatableFields.get(field2) == null) {
                            SourceLineAnnotation sla = SourceLineAnnotation.fromVisitedInstruction((BytecodeScanningDetector)this);
                            this.bloatableFields.put(field2, sla);
                        }
                        break block8;
                    }
                    if (seen == 176 && this.stack.getStackDepth() > 0 && (field = (returnItem = this.stack.getStackItem(0)).getXField()) != null) {
                        this.bloatableFields.remove(field);
                    }
                    break block8;
                }
                catch (Throwable throwable) {
                    Object var9_4 = null;
                    this.stack.sawOpcode((DismantleBytecode)this, seen);
                    throw throwable;
                }
            }
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            return;
        }
        Object var9_3 = null;
        this.stack.sawOpcode((DismantleBytecode)this, seen);
    }

    static {
        bloatableSigs.add("Ljava/util/concurrent/ArrayBlockingQueue;");
        bloatableSigs.add("Ljava/util/ArrayList;");
        bloatableSigs.add("Ljava/util/concurrent/BlockingQueue;");
        bloatableSigs.add("Ljava/util/Collection;");
        bloatableSigs.add("Ljava/util/concurrent/ConcurrentHashMap;");
        bloatableSigs.add("Ljava/util/concurrent/ConcurrentSkipListMap;");
        bloatableSigs.add("Ljava/util/concurrent/ConcurrentSkipListSet;");
        bloatableSigs.add("Ljava/util/concurrent/CopyOnWriteArraySet;");
        bloatableSigs.add("Ljava/util/EnumSet;");
        bloatableSigs.add("Ljava/util/EnumMap;");
        bloatableSigs.add("Ljava/util/HashMap;");
        bloatableSigs.add("Ljava/util/HashSet;");
        bloatableSigs.add("Ljava/util/Hashtable;");
        bloatableSigs.add("Ljava/util/IdentityHashMap;");
        bloatableSigs.add("Ljava/util/concurrent/LinkedBlockingQueue;");
        bloatableSigs.add("Ljava/util/LinkedHashMap;");
        bloatableSigs.add("Ljava/util/LinkedHashSet;");
        bloatableSigs.add("Ljava/util/LinkedList;");
        bloatableSigs.add("Ljava/util/List;");
        bloatableSigs.add("Ljava/util/concurrent/PriorityBlockingQueue;");
        bloatableSigs.add("Ljava/util/PriorityQueue;");
        bloatableSigs.add("Ljava/util/Map;");
        bloatableSigs.add("Ljava/util/Queue;");
        bloatableSigs.add("Ljava/util/Set;");
        bloatableSigs.add("Ljava/util/SortedSet;");
        bloatableSigs.add("Ljava/util/SortedMap;");
        bloatableSigs.add("Ljava/util/Stack;");
        bloatableSigs.add("Ljava/lang/StringBuffer;");
        bloatableSigs.add("Ljava/lang/StringBuilder;");
        bloatableSigs.add("Ljava/util/TreeMap;");
        bloatableSigs.add("Ljava/util/TreeSet;");
        bloatableSigs.add("Ljava/util/Vector;");
        decreasingMethods = new HashSet<String>();
        decreasingMethods.add("clear");
        decreasingMethods.add("delete");
        decreasingMethods.add("deleteCharAt");
        decreasingMethods.add("drainTo");
        decreasingMethods.add("poll");
        decreasingMethods.add("pollFirst");
        decreasingMethods.add("pollLast");
        decreasingMethods.add("pop");
        decreasingMethods.add("remove");
        decreasingMethods.add("removeAll");
        decreasingMethods.add("removeAllElements");
        decreasingMethods.add("removeElementAt");
        decreasingMethods.add("removeRange");
        decreasingMethods.add("setLength");
        decreasingMethods.add("take");
        increasingMethods = new HashSet<String>();
        increasingMethods.add("add");
        increasingMethods.add("addAll");
        increasingMethods.add("addElement");
        increasingMethods.add("addFirst");
        increasingMethods.add("addLast");
        increasingMethods.add("append");
        increasingMethods.add("insertElementAt");
        increasingMethods.add("offer");
        increasingMethods.add("put");
    }
}

