/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.bcel.classfile.Code;

public class SQLInLoop
extends BytecodeScanningDetector {
    private static final Set<String> queryClasses = new HashSet<String>();
    private static final Set<String> queryMethods;
    private final BugReporter bugReporter;
    List<Integer> queryLocations;
    List<LoopLocation> loops;

    public SQLInLoop(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        try {
            this.queryLocations = new ArrayList<Integer>();
            this.loops = new ArrayList<LoopLocation>();
            super.visitClassContext(classContext);
            Object var3_2 = null;
            this.queryLocations = null;
            this.loops = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.queryLocations = null;
            this.loops = null;
            throw throwable;
        }
    }

    public void visitCode(Code obj) {
        this.queryLocations.clear();
        this.loops.clear();
        super.visitCode(obj);
        block0: for (Integer qLoc : this.queryLocations) {
            for (LoopLocation lLoc : this.loops) {
                if (!lLoc.isInLoop(qLoc)) continue;
                this.bugReporter.reportBug(new BugInstance((Detector)this, "SIL_SQL_IN_LOOP", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this, qLoc.intValue()));
                continue block0;
            }
        }
    }

    public void sawOpcode(int seen) {
        int pc;
        int branchTarget;
        if (seen == 185) {
            String clsName = this.getClassConstantOperand();
            String methodName = this.getNameConstantOperand();
            if (queryClasses.contains(clsName) && queryMethods.contains(methodName)) {
                this.queryLocations.add(this.getPC());
            }
        } else if ((seen == 167 || seen == 200) && (branchTarget = this.getBranchTarget()) < (pc = this.getPC())) {
            this.loops.add(new LoopLocation(branchTarget, pc));
        }
    }

    static {
        queryClasses.add("java/sql/Statement");
        queryClasses.add("java/sql/PreparedStatement");
        queryClasses.add("java/sql/CallableStatement");
        queryMethods = new HashSet<String>();
        queryMethods.add("execute");
        queryMethods.add("executeQuery");
    }

    private static class LoopLocation {
        private final int startPC;
        private final int endPC;

        public LoopLocation(int start, int end) {
            this.startPC = start;
            this.endPC = end;
        }

        public boolean isInLoop(int pc) {
            return pc >= this.startPC && pc <= this.endPC;
        }
    }
}

