/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.TernaryPatcher;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.generic.Type;

@OpcodeStack.CustomUserValue
public class SideEffectConstructor
extends BytecodeScanningDetector {
    private final BugReporter bugReporter;
    private OpcodeStack stack;
    private State state;

    public SideEffectConstructor(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        try {
            this.stack = new OpcodeStack();
            super.visitClassContext(classContext);
            Object var3_2 = null;
            this.stack = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.stack = null;
            throw throwable;
        }
    }

    public void visitCode(Code obj) {
        this.state = State.SAW_NOTHING;
        this.stack.resetForMethodEntry((DismantleBytecode)this);
        super.visitCode(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sawOpcode(int seen) {
        int pc = 0;
        try {
            this.stack.precomputation((DismantleBytecode)this);
            block1 : switch (this.state) {
                case SAW_NOTHING: {
                    if (seen == 183) {
                        String name = this.getNameConstantOperand();
                        if ("<init>".equals(name)) {
                            OpcodeStack.Item caller;
                            String sig = this.getSigConstantOperand();
                            int numArgs = Type.getArgumentTypes((String)sig).length;
                            if (this.stack.getStackDepth() > numArgs && (caller = this.stack.getStackItem(numArgs)).getRegisterNumber() != 0) {
                                this.state = State.SAW_CTOR;
                                pc = this.getPC();
                            }
                        }
                    } else {
                        if (seen != 177) break;
                        int depth = this.stack.getStackDepth();
                        for (int i = 0; i < depth; ++i) {
                            OpcodeStack.Item item = this.stack.getStackItem(i);
                            Integer secPC = (Integer)item.getUserValue();
                            if (secPC == null) continue;
                            this.bugReporter.reportBug(new BugInstance((Detector)this, "SEC_SIDE_EFFECT_CONSTRUCTOR", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this, secPC.intValue()));
                            break block1;
                        }
                    }
                    break;
                }
                case SAW_CTOR: {
                    if (seen == 87 || seen == 177) {
                        this.bugReporter.reportBug(new BugInstance((Detector)this, "SEC_SIDE_EFFECT_CONSTRUCTOR", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                    }
                    this.state = State.SAW_NOTHING;
                }
            }
            Object var8_11 = null;
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            TernaryPatcher.pre(this.stack, seen);
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            TernaryPatcher.post(this.stack, seen);
            if (pc != 0 && this.stack.getStackDepth() > 0) {
                OpcodeStack.Item item = this.stack.getStackItem(0);
                item.setUserValue((Object)pc);
            }
            throw throwable;
        }
        TernaryPatcher.pre(this.stack, seen);
        this.stack.sawOpcode((DismantleBytecode)this, seen);
        TernaryPatcher.post(this.stack, seen);
        if (pc != 0 && this.stack.getStackDepth() > 0) {
            OpcodeStack.Item item = this.stack.getStackItem(0);
            item.setUserValue((Object)pc);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        SAW_NOTHING,
        SAW_CTOR;

    }
}

