/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class SpuriousThreadStates
extends BytecodeScanningDetector {
    private BugReporter bugReporter;
    private OpcodeStack stack;

    public SpuriousThreadStates(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        try {
            this.stack = new OpcodeStack();
            super.visitClassContext(classContext);
            Object var3_2 = null;
            this.stack = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.stack = null;
            throw throwable;
        }
    }

    public void visitMethod(Method obj) {
        this.stack.resetForMethodEntry((DismantleBytecode)this);
        super.visitMethod(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sawOpcode(int seen) {
        OpcodeStack.Item itm = null;
        try {
            block15: {
                try {
                    String className;
                    this.stack.precomputation((DismantleBytecode)this);
                    if (seen != 182 || !"java/lang/Object".equals(className = this.getClassConstantOperand())) break block15;
                    String methodName = this.getNameConstantOperand();
                    String signature = this.getSigConstantOperand();
                    if (("wait".equals(methodName) || "notify".equals(methodName) || "notifyAll".equals(methodName)) && "()V".equals(signature)) {
                        if (this.stack.getStackDepth() > 0) {
                            itm = this.stack.getStackItem(0);
                        }
                    } else if ("wait".equals(methodName) && "(L)V".equals(signature)) {
                        if (this.stack.getStackDepth() > 1) {
                            itm = this.stack.getStackItem(1);
                        }
                    } else if ("wait".equals(methodName) && "(LI)V".equals(signature) && this.stack.getStackDepth() > 2) {
                        itm = this.stack.getStackItem(2);
                    }
                    if (itm == null) break block15;
                    JavaClass cls = itm.getJavaClass();
                    boolean found = false;
                    if (cls != null) {
                        if ("java.lang.Thread".equals(cls.getClassName())) {
                            found = true;
                        } else {
                            JavaClass[] supers;
                            for (JavaClass jc : supers = cls.getSuperClasses()) {
                                if (!"java.lang.Thread".equals(jc.getClassName())) continue;
                                found = true;
                                break;
                            }
                        }
                    }
                    if (!found) break block15;
                    this.bugReporter.reportBug(new BugInstance((Detector)this, "STS_SPURIOUS_THREAD_STATES", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                }
                catch (ClassNotFoundException cnfe) {
                    this.bugReporter.reportMissingClass(cnfe);
                    Object var14_15 = null;
                    this.stack.sawOpcode((DismantleBytecode)this, seen);
                    return;
                }
            }
            Object var14_14 = null;
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            return;
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            throw throwable;
        }
    }
}

