/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.generic.Type;

public class SuspiciousComparatorReturnValues
extends BytecodeScanningDetector {
    private static Map<JavaClass, String> compareClasses = new HashMap<JavaClass, String>();
    private OpcodeStack stack;
    private final BugReporter bugReporter;
    private String[] methodInfo;
    private boolean indeterminate;
    private boolean seenNegative;
    private boolean seenPositive;
    private boolean seenZero;

    public SuspiciousComparatorReturnValues(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        try {
            try {
                JavaClass cls = classContext.getJavaClass();
                for (Map.Entry<JavaClass, String> entry : compareClasses.entrySet()) {
                    if (!cls.implementationOf(entry.getKey())) continue;
                    this.methodInfo = entry.getValue().split(":");
                    this.stack = new OpcodeStack();
                    super.visitClassContext(classContext);
                    break;
                }
                Object var6_6 = null;
                this.methodInfo = null;
                this.stack = null;
            }
            catch (ClassNotFoundException cnfe) {
                this.bugReporter.reportMissingClass(cnfe);
                Object var6_7 = null;
                this.methodInfo = null;
                this.stack = null;
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.methodInfo = null;
            this.stack = null;
            throw throwable;
        }
    }

    public void visitCode(Code obj) {
        String methodName = this.getMethodName();
        String methodSig = this.getMethodSig();
        if (methodName.equals(this.methodInfo[0]) && methodSig.endsWith(this.methodInfo[2]) && Type.getArgumentTypes((String)methodSig).length == Integer.parseInt(this.methodInfo[1])) {
            boolean seenAll;
            this.stack.resetForMethodEntry((DismantleBytecode)this);
            this.indeterminate = false;
            this.seenNegative = false;
            this.seenPositive = false;
            this.seenZero = false;
            super.visitCode(obj);
            if (!this.indeterminate && !(seenAll = this.seenNegative & this.seenPositive & this.seenZero)) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, "SC_SUSPICIOUS_COMPARATOR_RETURN_VALUES", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this, 0));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sawOpcode(int seen) {
        block13: {
            block12: {
                try {
                    OpcodeStack.Item item;
                    String exSig;
                    if (this.indeterminate) {
                        Object var6_2 = null;
                        break block12;
                    }
                    this.stack.precomputation((DismantleBytecode)this);
                    if (seen == 172) {
                        if (this.stack.getStackDepth() > 0) {
                            OpcodeStack.Item item2 = this.stack.getStackItem(0);
                            Integer returnValue = (Integer)item2.getConstant();
                            if (returnValue == null) {
                                this.indeterminate = true;
                                break block13;
                            }
                            int v = returnValue;
                            if (v < 0) {
                                this.seenNegative = true;
                                break block13;
                            }
                            if (v > 0) {
                                this.seenPositive = true;
                                break block13;
                            } else {
                                this.seenZero = true;
                            }
                            break block13;
                        }
                        this.indeterminate = true;
                        break block13;
                    }
                    if (seen == 167 || seen == 200) {
                        if (this.stack.getStackDepth() > 0) {
                            this.indeterminate = true;
                        }
                        break block13;
                    }
                    if (seen == 191 && this.stack.getStackDepth() > 0 && "Ljava/lang/UnsupportedOperationException;".equals(exSig = (item = this.stack.getStackItem(0)).getSignature())) {
                        this.indeterminate = true;
                    }
                    break block13;
                }
                catch (Throwable throwable) {
                    Object var6_4 = null;
                    this.stack.sawOpcode((DismantleBytecode)this, seen);
                    throw throwable;
                }
            }
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            return;
        }
        Object var6_3 = null;
        this.stack.sawOpcode((DismantleBytecode)this, seen);
    }

    static {
        try {
            compareClasses.put(Repository.lookupClass((String)"java/lang/Comparable"), "compareTo:1:I");
            compareClasses.put(Repository.lookupClass((String)"java/util/Comparator"), "compare:2:I");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

