/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.classfile.Code;

public class SuspiciousGetterSetterUse
extends BytecodeScanningDetector {
    private final BugReporter bugReporter;
    private State state;
    private String beanReference1;
    private String beanReference2;
    private String propName;
    private String propType;
    private boolean sawField;

    public SuspiciousGetterSetterUse(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitCode(Code obj) {
        this.state = State.SEEN_NOTHING;
        this.beanReference1 = null;
        this.beanReference2 = null;
        this.propName = null;
        this.propType = null;
        this.sawField = false;
        super.visitCode(obj);
    }

    public void sawOpcode(int seen) {
        boolean reset = true;
        switch (this.state) {
            case SEEN_NOTHING: {
                switch (seen) {
                    case 25: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: {
                        this.beanReference1 = String.valueOf(this.getRegisterOperand());
                        this.state = State.SEEN_ALOAD;
                        reset = false;
                    }
                }
                break;
            }
            case SEEN_ALOAD: {
                switch (seen) {
                    case 25: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: {
                        if (this.sawField || !this.beanReference1.equals(String.valueOf(this.getRegisterOperand()))) break;
                        this.state = State.SEEN_DUAL_LOADS;
                        reset = false;
                        break;
                    }
                    case 180: {
                        if (this.sawField) {
                            this.beanReference2 = this.beanReference2 + ":" + this.getNameConstantOperand();
                            if (!this.beanReference1.equals(this.beanReference2)) break;
                            this.state = State.SEEN_DUAL_LOADS;
                            reset = false;
                            break;
                        }
                        this.state = State.SEEN_GETFIELD;
                        this.beanReference1 = this.beanReference1 + ":" + this.getNameConstantOperand();
                        this.sawField = true;
                        reset = false;
                    }
                }
                break;
            }
            case SEEN_GETFIELD: {
                switch (seen) {
                    case 25: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: {
                        this.beanReference2 = String.valueOf(this.getRegisterOperand());
                        this.state = State.SEEN_ALOAD;
                        reset = false;
                    }
                }
                break;
            }
            case SEEN_DUAL_LOADS: {
                String sig;
                if (seen != 182 || !(sig = this.getSigConstantOperand()).startsWith("()")) break;
                this.propType = sig.substring("()".length());
                if (this.propType.equals("V")) break;
                this.propName = this.getNameConstantOperand();
                if (!this.propName.startsWith("get")) break;
                this.propName = this.propName.substring("get".length());
                this.state = State.SEEN_INVOKEVIRTUAL;
                reset = false;
                break;
            }
            case SEEN_INVOKEVIRTUAL: {
                String name;
                String sig;
                if (seen != 182 || !(sig = this.getSigConstantOperand()).equals("(" + this.propType + ")V") || !(name = this.getNameConstantOperand()).startsWith("set") || !this.propName.equals(name.substring("set".length()))) break;
                this.bugReporter.reportBug(new BugInstance((Detector)this, "SGSU_SUSPICIOUS_GETTER_SETTER_USE", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
            }
        }
        if (reset) {
            this.beanReference1 = null;
            this.beanReference2 = null;
            this.propType = null;
            this.propName = null;
            this.sawField = false;
            this.state = State.SEEN_NOTHING;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        SEEN_NOTHING,
        SEEN_ALOAD,
        SEEN_GETFIELD,
        SEEN_DUAL_LOADS,
        SEEN_INVOKEVIRTUAL;

    }
}

