/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuspiciousJDKVersionUse
extends BytecodeScanningDetector {
    private static final Map<Integer, String> verRegEx = new HashMap<Integer, String>();
    private static final Map<Integer, String> versionStrings;
    private static final Pattern jarPattern;
    private static final String SJVU_JDKHOME = "fb-contrib.sjvu.jdkhome";
    private final Map<String, File> versionPaths;
    private final Map<Integer, Map<String, Set<String>>> validMethodsByVersion;
    private final Map<String, String> superNames;
    private File jdksRoot = null;
    private ZipFile jdkZip;
    private Integer clsMajorVersion;
    private final BugReporter bugReporter;

    public SuspiciousJDKVersionUse(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        this.versionPaths = new HashMap<String, File>();
        this.validMethodsByVersion = new HashMap<Integer, Map<String, Set<String>>>();
        this.superNames = new HashMap<String, String>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void visitClassContext(ClassContext classContext) {
        block15: {
            block13: {
                this.clsMajorVersion = classContext.getJavaClass().getMajor();
                File rtJar = this.getRTJarFile();
                if (rtJar == null) {
                    rtJar = this.getRTJarFromProperty();
                }
                if (rtJar != null) {
                    this.jdkZip = new ZipFile(rtJar);
                    super.visitClassContext(classContext);
                    break block13;
                }
                String version = versionStrings.get(this.clsMajorVersion);
                ClassNotFoundException cnfe = version != null ? new ClassNotFoundException("The " + version + " rt.jar was not found. This file is needed for finding invalid methods with the SuspiciousJDKVersionUse detector. The system property 'fb-contrib.sjvu.jdkhome' can be used to specify the location of the appropriate JDK.") : new ClassNotFoundException("The JDK's rt.jar for classes with class version " + this.clsMajorVersion + " was not found. This file is needed for finding invalid methods with the SuspiciousJDKVersionUse detector. The system property 'fb-contrib.sjvu.jdkhome' can be used to specify the location of the appropriate JDK.");
                cnfe.fillInStackTrace();
                this.bugReporter.reportMissingClass(cnfe);
            }
            Object var6_6 = null;
            this.clsMajorVersion = null;
            try {
                if (this.jdkZip != null) {
                    this.jdkZip.close();
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
            this.jdkZip = null;
            {
                break block15;
                catch (IOException iOException) {
                    Object var6_7 = null;
                    this.clsMajorVersion = null;
                    try {
                        if (this.jdkZip != null) {
                            this.jdkZip.close();
                        }
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    this.jdkZip = null;
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                this.clsMajorVersion = null;
                try {
                    if (this.jdkZip != null) {
                        this.jdkZip.close();
                    }
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                this.jdkZip = null;
                throw throwable;
            }
        }
    }

    public void sawOpcode(int seen) {
        try {
            String clsName;
            if ((seen == 182 || seen == 184 || seen == 183) && ((clsName = this.getClassConstantOperand()).startsWith("java/") || clsName.startsWith("javax/"))) {
                Method m = this.findCalledMethod();
                if (m == null) {
                    return;
                }
                Map<String, Set<String>> validMethods = this.validMethodsByVersion.get(this.clsMajorVersion);
                if (validMethods == null) {
                    validMethods = new HashMap<String, Set<String>>();
                    this.validMethodsByVersion.put(this.clsMajorVersion, validMethods);
                }
                if (!this.isValid(validMethods, clsName)) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, "SJVU_SUSPICIOUS_JDK_VERSION_USE", 1).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this).addCalledMethod((DismantleBytecode)this));
                }
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Method findCalledMethod() {
        try {
            JavaClass clss = Repository.lookupClass((String)this.getClassConstantOperand());
            Method[] methods = clss.getMethods();
            String calledMethod = this.getNameConstantOperand();
            String calledSignature = this.getSigConstantOperand();
            for (Method m : methods) {
                if (!m.getName().equals(calledMethod) || !m.getSignature().equals(calledSignature)) continue;
                return m;
            }
            return null;
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isValid(Map<String, Set<String>> validMethods, String clsName) throws IOException, ClassNotFoundException {
        boolean bl;
        block22: {
            InputStream is;
            block16: {
                boolean bl2;
                block21: {
                    block19: {
                        boolean bl3;
                        block20: {
                            block17: {
                                boolean bl4;
                                block18: {
                                    is = null;
                                    try {
                                        Set<String> methodInfos = validMethods.get(clsName);
                                        if (methodInfos == null) {
                                            ZipEntry ze = this.jdkZip.getEntry(clsName + ".class");
                                            if (ze != null) {
                                                is = new BufferedInputStream(this.jdkZip.getInputStream(ze));
                                                ClassParser parser = new ClassParser(is, clsName);
                                                JavaClass calledClass = parser.parse();
                                                this.superNames.put(clsName, calledClass.getSuperclassName().replace('.', '/'));
                                                Method[] methods = calledClass.getMethods();
                                                methodInfos = new HashSet<String>(methods.length);
                                                validMethods.put(clsName, methodInfos);
                                                for (Method m : methods) {
                                                    methodInfos.add(m.getName() + m.getSignature());
                                                }
                                            } else if (clsName.startsWith("java/")) {
                                                this.bugReporter.reportBug(new BugInstance((Detector)this, "SJVU_SUSPICIOUS_JDK_VERSION_USE", 1).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this).addClass(clsName));
                                            }
                                        }
                                        if (methodInfos == null) break block16;
                                        String wantedMethod = this.getNameConstantOperand() + this.getSigConstantOperand();
                                        if (!methodInfos.contains(wantedMethod)) break block17;
                                        bl4 = true;
                                        Object var14_17 = null;
                                        if (is == null) break block18;
                                    }
                                    catch (Throwable throwable) {
                                        block23: {
                                            Object var14_21 = null;
                                            if (is == null) break block23;
                                            try {
                                                is.close();
                                            }
                                            catch (IOException ioe) {}
                                        }
                                        throw throwable;
                                    }
                                    try {
                                        is.close();
                                    }
                                    catch (IOException ioe) {
                                        // empty catch block
                                    }
                                }
                                return bl4;
                            }
                            if (!"java/lang/Object".equals(clsName)) break block19;
                            bl3 = false;
                            Object var14_18 = null;
                            if (is == null) break block20;
                            try {
                                is.close();
                            }
                            catch (IOException ioe) {
                                // empty catch block
                            }
                        }
                        return bl3;
                    }
                    bl2 = this.isValid(validMethods, this.superNames.get(clsName));
                    Object var14_19 = null;
                    if (is == null) break block21;
                    try {
                        is.close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
                return bl2;
            }
            bl = true;
            Object var14_20 = null;
            if (is == null) break block22;
            try {
                is.close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        return bl;
    }

    private File getRTJarFile() {
        Matcher m;
        URL jdkUrl;
        String versionStr = verRegEx.get(this.clsMajorVersion);
        if (versionStr == null) {
            return null;
        }
        File rtPath = this.versionPaths.get(versionStr);
        if (rtPath != null) {
            return rtPath;
        }
        if (this.jdksRoot == null && (jdkUrl = SuspiciousJDKVersionUse.class.getResource("/java/lang/Object.class")) != null && (m = jarPattern.matcher(jdkUrl.toExternalForm())).find()) {
            String path = m.group(1);
            this.jdksRoot = new File(path);
            Pattern verPat = Pattern.compile(versionStr);
            m = verPat.matcher(this.jdksRoot.getName());
            while (this.jdksRoot.getParentFile() != null && !m.find()) {
                this.jdksRoot = this.jdksRoot.getParentFile();
                m = verPat.matcher(this.jdksRoot.getName());
            }
            if (this.jdksRoot.getParentFile() == null) {
                return null;
            }
            try {
                String encoding = System.getProperty("file.encoding");
                this.jdksRoot = new File(URLDecoder.decode(this.jdksRoot.getParentFile().getPath(), encoding));
            }
            catch (UnsupportedEncodingException uee) {
                return null;
            }
        }
        if (this.jdksRoot != null) {
            File[] possibleJdks;
            for (File possibleJdk : possibleJdks = this.jdksRoot.listFiles()) {
                Pattern verPat = Pattern.compile(versionStr);
                Matcher m2 = verPat.matcher(possibleJdk.getName());
                if (!m2.find()) continue;
                File wantedRtJar = new File(possibleJdk, "lib/rt.jar");
                if (!wantedRtJar.exists() && !(wantedRtJar = new File(possibleJdk, "jre/lib/rt.jar")).exists()) {
                    return null;
                }
                this.versionPaths.put(versionStr, wantedRtJar);
                return wantedRtJar;
            }
        }
        return null;
    }

    private File getRTJarFromProperty() {
        String jdkHome = System.getProperty(SJVU_JDKHOME);
        if (jdkHome == null) {
            return null;
        }
        File rtJar = new File(jdkHome, "lib/rt.jar");
        if (rtJar.exists()) {
            return rtJar;
        }
        rtJar = new File(jdkHome, "jre/lib/rt.jar");
        if (rtJar.exists()) {
            return rtJar;
        }
        return null;
    }

    static {
        verRegEx.put(45, "(jdk|j2?re)1.1");
        verRegEx.put(46, "(jdk|j2?re)1.2");
        verRegEx.put(47, "(jdk|j2?re)1.3");
        verRegEx.put(48, "(jdk|j2?re)1.4");
        verRegEx.put(49, "(jdk|j2?re)1.5");
        verRegEx.put(50, "(jdk|j2?re)1.6");
        verRegEx.put(51, "(jdk|j2?re)1.7");
        verRegEx.put(52, "(jdk|j2?re)1.8");
        versionStrings = new HashMap<Integer, String>();
        versionStrings.put(45, "JDK 1.1");
        versionStrings.put(46, "JDK 1.2");
        versionStrings.put(47, "JDK 1.3");
        versionStrings.put(48, "JDK 1.4");
        versionStrings.put(49, "JDK 1.5");
        versionStrings.put(50, "JDK 1.6");
        versionStrings.put(51, "JDK 1.7");
        versionStrings.put(52, "JDK 1.8");
        jarPattern = Pattern.compile("jar:file:/*([^!]*)");
    }
}

