/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashSet;
import java.util.Set;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class SuspiciousWaitOnConcurrentObject
extends BytecodeScanningDetector {
    private static final Set<String> concurrentAwaitClasses = new HashSet<String>();
    private BugReporter bugReporter;
    private OpcodeStack stack;

    public SuspiciousWaitOnConcurrentObject(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        try {
            JavaClass cls = classContext.getJavaClass();
            int major = cls.getMajor();
            if (major >= 49) {
                this.stack = new OpcodeStack();
                super.visitClassContext(classContext);
            }
            Object var5_4 = null;
            this.stack = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.stack = null;
            throw throwable;
        }
    }

    public void visitMethod(Method obj) {
        this.stack.resetForMethodEntry((DismantleBytecode)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sawOpcode(int seen) {
        try {
            block4: {
                try {
                    String clsName;
                    OpcodeStack.Item itm;
                    JavaClass cls;
                    String methodName;
                    this.stack.precomputation((DismantleBytecode)this);
                    if (seen != 182 || !"wait".equals(methodName = this.getNameConstantOperand()) || this.stack.getStackDepth() <= 0 || (cls = (itm = this.stack.getStackItem(0)).getJavaClass()) == null || !concurrentAwaitClasses.contains(clsName = cls.getClassName())) break block4;
                    this.bugReporter.reportBug(new BugInstance((Detector)this, "SWCO_SUSPICIOUS_WAIT_ON_CONCURRENT_OBJECT", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                }
                catch (ClassNotFoundException cnfe) {
                    this.bugReporter.reportMissingClass(cnfe);
                    Object var7_8 = null;
                    this.stack.sawOpcode((DismantleBytecode)this, seen);
                    return;
                }
            }
            Object var7_7 = null;
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            return;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            throw throwable;
        }
    }

    static {
        concurrentAwaitClasses.add("java.util.concurrent.CountDownLatch");
        concurrentAwaitClasses.add("java.util.concurrent.CyclicBarrier");
    }
}

