/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Signature;
import org.apache.bcel.classfile.Visitor;

public class UnboundMethodTemplateParameter
extends PreorderVisitor
implements Detector {
    private static final Pattern TEMPLATED_SIGNATURE = Pattern.compile("(\\<[^\\>]+\\>)(.+)");
    private static final Pattern TEMPLATE = Pattern.compile("\\<?([^:]+):[^;]*;");
    private BugReporter bugReporter;

    public UnboundMethodTemplateParameter(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        JavaClass cls = classContext.getJavaClass();
        cls.accept((Visitor)this);
    }

    public void visitMethod(Method obj) {
        Attribute[] attributes;
        for (Attribute a : attributes = obj.getAttributes()) {
            if (!a.getName().equals("Signature")) continue;
            TemplateSignature ts = this.parseSignatureAttribute((Signature)a);
            if (ts != null) {
                for (String templateParm : ts.templateParameters) {
                    if (ts.signature.contains("T" + templateParm + ";") || ts.signature.contains("[T" + templateParm + ";")) continue;
                    this.bugReporter.reportBug(new BugInstance((Detector)this, "UMTP_UNBOUND_METHOD_TEMPLATE_PARAMETER", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addString("Template Parameter: " + templateParm));
                    return;
                }
            }
            return;
        }
    }

    public void report() {
    }

    private TemplateSignature parseSignatureAttribute(Signature signatureAttribute) {
        Matcher m = TEMPLATED_SIGNATURE.matcher(signatureAttribute.getSignature());
        if (m.matches()) {
            TemplateSignature ts = new TemplateSignature();
            ts.signature = m.group(2);
            String template = m.group(1);
            m = TEMPLATE.matcher(template);
            ArrayList<String> templates = new ArrayList<String>(4);
            while (m.find()) {
                templates.add(m.group(1));
            }
            ts.templateParameters = templates.toArray(new String[templates.size()]);
            return ts;
        }
        return null;
    }

    static class TemplateSignature {
        String[] templateParameters;
        String signature;

        TemplateSignature() {
        }
    }
}

