/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.SignatureUtils;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnrelatedReturnValues
extends BytecodeScanningDetector {
    private final BugReporter bugReporter;
    private OpcodeStack stack;
    private JavaClass currentClass;
    private Map<JavaClass, Integer> returnTypes;

    public UnrelatedReturnValues(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        try {
            this.currentClass = classContext.getJavaClass();
            this.stack = new OpcodeStack();
            this.returnTypes = new HashMap<JavaClass, Integer>();
            super.visitClassContext(classContext);
            Object var3_2 = null;
            this.currentClass = null;
            this.stack = null;
            this.returnTypes = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.currentClass = null;
            this.stack = null;
            this.returnTypes = null;
            throw throwable;
        }
    }

    public void visitCode(Code obj) {
        try {
            Method m = this.getMethod();
            String signature = m.getSignature();
            if (signature.endsWith(")Ljava/lang/Object;")) {
                this.stack.resetForMethodEntry((DismantleBytecode)this);
                this.returnTypes.clear();
                super.visitCode(obj);
                if (this.returnTypes.size() > 1) {
                    BugInstance bug;
                    JavaClass cls;
                    String methodName = m.getName();
                    boolean isInherited = SignatureUtils.isInheritedMethod(this.currentClass, methodName, signature);
                    int priority = 2;
                    for (JavaClass cls2 : this.returnTypes.keySet()) {
                        if (cls2 == null || !"java.lang.Object".equals(cls2.getClassName())) continue;
                        priority = 3;
                        break;
                    }
                    if ((cls = this.findCommonType(this.returnTypes.keySet())) != null && !isInherited) {
                        bug = new BugInstance((Detector)this, "URV_CHANGE_RETURN_TYPE", priority).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this);
                        bug.addString(cls.getClassName());
                    } else if (!isInherited) {
                        bug = new BugInstance((Detector)this, "URV_UNRELATED_RETURN_VALUES", priority).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this);
                    } else {
                        bug = new BugInstance((Detector)this, "URV_INHERITED_METHOD_WITH_RELATED_TYPES", priority).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this);
                        if (cls != null) {
                            bug.addString(cls.getClassName());
                        }
                    }
                    if (bug != null) {
                        for (Integer pc : this.returnTypes.values()) {
                            bug.addSourceLine((BytecodeScanningDetector)this, pc.intValue());
                        }
                        this.bugReporter.reportBug(bug);
                    }
                }
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sawOpcode(int seen) {
        try {
            block4: {
                try {
                    OpcodeStack.Item itm;
                    this.stack.precomputation((DismantleBytecode)this);
                    if (seen != 176 || this.stack.getStackDepth() <= 0 || (itm = this.stack.getStackItem(0)).isNull()) break block4;
                    this.returnTypes.put(itm.getJavaClass(), this.getPC());
                }
                catch (ClassNotFoundException cnfe) {
                    this.bugReporter.reportMissingClass(cnfe);
                    Object var4_5 = null;
                    this.stack.sawOpcode((DismantleBytecode)this, seen);
                    return;
                }
            }
            Object var4_4 = null;
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            return;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            throw throwable;
        }
    }

    public JavaClass findCommonType(Set<JavaClass> classes) throws ClassNotFoundException {
        HashSet<JavaClass> possibleCommonTypes = new HashSet<JavaClass>();
        boolean populate = true;
        for (JavaClass cls : classes) {
            if (cls == null) {
                return null;
            }
            if ("java/lang/Object".equals(cls.getClassName())) continue;
            JavaClass[] infs = cls.getAllInterfaces();
            JavaClass[] supers = cls.getSuperClasses();
            if (populate) {
                possibleCommonTypes.addAll(Arrays.asList(infs));
                possibleCommonTypes.addAll(Arrays.asList(supers));
                possibleCommonTypes.remove(Repository.lookupClass((String)"java/lang/Object"));
                populate = false;
                continue;
            }
            HashSet<JavaClass> retain = new HashSet<JavaClass>();
            retain.addAll(Arrays.asList(infs));
            retain.addAll(Arrays.asList(supers));
            possibleCommonTypes.retainAll(retain);
        }
        if (possibleCommonTypes.isEmpty()) {
            return null;
        }
        for (JavaClass cls : possibleCommonTypes) {
            if (!cls.isInterface()) continue;
            return cls;
        }
        return (JavaClass)possibleCommonTypes.iterator().next();
    }
}

