/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.RegisterUtils;
import com.mebigfatguy.fbcontrib.utils.TernaryPatcher;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

@OpcodeStack.CustomUserValue
public class UseEnumCollections
extends BytecodeScanningDetector {
    private static final Set<String> nonEnumCollections = new HashSet<String>();
    private final BugReporter bugReporter;
    private OpcodeStack stack;
    private Set<String> checkedFields;
    private Map<Integer, Boolean> enumRegs;
    private Map<String, Boolean> enumFields;
    private boolean methodReported;

    public UseEnumCollections(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        try {
            JavaClass cls = classContext.getJavaClass();
            if (cls.getMajor() >= 49) {
                this.stack = new OpcodeStack();
                this.checkedFields = new HashSet<String>();
                this.enumRegs = new HashMap<Integer, Boolean>();
                this.enumFields = new HashMap<String, Boolean>();
                super.visitClassContext(classContext);
            }
            Object var4_3 = null;
            this.stack = null;
            this.checkedFields = null;
            this.enumRegs = null;
            this.enumFields = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.stack = null;
            this.checkedFields = null;
            this.enumRegs = null;
            this.enumFields = null;
            throw throwable;
        }
    }

    public void visitMethod(Method obj) {
        this.stack.resetForMethodEntry((DismantleBytecode)this);
        this.methodReported = false;
        this.enumRegs.clear();
        super.visitMethod(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sawOpcode(int seen) {
        Boolean sawEnumCollectionCreation;
        block26: {
            block25: {
                sawEnumCollectionCreation = null;
                try {
                    try {
                        this.stack.precomputation((DismantleBytecode)this);
                        if (this.methodReported) {
                            Object var8_3 = null;
                            break block25;
                        }
                        if (seen == 184) {
                            String clsName = this.getClassConstantOperand();
                            String signature = this.getSigConstantOperand();
                            if ("java/util/EnumSet".equals(clsName) && signature.endsWith(")Ljava/util/EnumSet;")) {
                                sawEnumCollectionCreation = Boolean.TRUE;
                            }
                            break block26;
                        }
                        if (seen == 183) {
                            String clsName = this.getClassConstantOperand();
                            String methodName = this.getNameConstantOperand();
                            if ("java/util/EnumMap".equals(clsName) && "<init>".equals(methodName)) {
                                sawEnumCollectionCreation = Boolean.TRUE;
                                break block26;
                            }
                            if (clsName.startsWith("java/util/") && (clsName.endsWith("Map") || clsName.endsWith("Set"))) {
                                sawEnumCollectionCreation = Boolean.FALSE;
                            }
                            break block26;
                        }
                        if (seen == 58 || seen >= 75 && seen <= 78) {
                            if (this.stack.getStackDepth() > 0) {
                                OpcodeStack.Item itm = this.stack.getStackItem(0);
                                Integer reg = RegisterUtils.getAStoreReg((DismantleBytecode)this, seen);
                                if (itm.getUserValue() != null) {
                                    this.enumRegs.put(reg, (Boolean)itm.getUserValue());
                                    break block26;
                                } else {
                                    this.enumRegs.remove(reg);
                                }
                            }
                            break block26;
                        }
                        if (seen == 25 || seen >= 42 && seen <= 45) {
                            Integer reg = RegisterUtils.getALoadReg((DismantleBytecode)this, seen);
                            sawEnumCollectionCreation = this.enumRegs.get(reg);
                            break block26;
                        }
                        if (seen == 181) {
                            if (this.stack.getStackDepth() > 0) {
                                String fieldName = this.getNameConstantOperand();
                                OpcodeStack.Item itm = this.stack.getStackItem(0);
                                if (itm.getUserValue() != null) {
                                    this.enumFields.put(fieldName, (Boolean)itm.getUserValue());
                                    break block26;
                                } else {
                                    this.enumFields.remove(fieldName);
                                }
                            }
                            break block26;
                        }
                        if (seen == 180) {
                            String fieldName = this.getNameConstantOperand();
                            sawEnumCollectionCreation = this.enumFields.get(fieldName);
                            break block26;
                        }
                        if (seen != 185) break block26;
                        boolean bug = false;
                        String clsName = this.getClassConstantOperand();
                        String methodName = this.getNameConstantOperand();
                        String signature = this.getSigConstantOperand();
                        if ("java/util/Map".equals(clsName) && "put".equals(methodName) && "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;".equals(signature)) {
                            bug = this.isEnum(1) && !this.isEnumCollection(2) && !this.alreadyReported(2);
                        } else if ("java/util/Set".equals(clsName) && "add".equals(methodName) && "(Ljava/lang/Object;)Z".equals(signature)) {
                            boolean bl = bug = this.isEnum(0) && !this.isEnumCollection(1) && !this.alreadyReported(1);
                        }
                        if (bug) {
                            this.bugReporter.reportBug(new BugInstance((Detector)this, "UEC_USE_ENUM_COLLECTIONS", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                            this.methodReported = true;
                        }
                        break block26;
                    }
                    catch (ClassNotFoundException cnfe) {
                        this.bugReporter.reportMissingClass(cnfe);
                        Object var8_5 = null;
                        TernaryPatcher.pre(this.stack, seen);
                        this.stack.sawOpcode((DismantleBytecode)this, seen);
                        TernaryPatcher.post(this.stack, seen);
                        if (sawEnumCollectionCreation == null) return;
                        if (this.stack.getStackDepth() <= 0) return;
                        OpcodeStack.Item itm = this.stack.getStackItem(0);
                        itm.setUserValue((Object)sawEnumCollectionCreation);
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var8_6 = null;
                    TernaryPatcher.pre(this.stack, seen);
                    this.stack.sawOpcode((DismantleBytecode)this, seen);
                    TernaryPatcher.post(this.stack, seen);
                    if (sawEnumCollectionCreation == null) throw throwable;
                    if (this.stack.getStackDepth() <= 0) throw throwable;
                    OpcodeStack.Item itm = this.stack.getStackItem(0);
                    itm.setUserValue((Object)sawEnumCollectionCreation);
                    throw throwable;
                }
            }
            TernaryPatcher.pre(this.stack, seen);
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            TernaryPatcher.post(this.stack, seen);
            if (sawEnumCollectionCreation == null) return;
            if (this.stack.getStackDepth() <= 0) return;
            OpcodeStack.Item itm = this.stack.getStackItem(0);
            itm.setUserValue((Object)sawEnumCollectionCreation);
            return;
        }
        Object var8_4 = null;
        TernaryPatcher.pre(this.stack, seen);
        this.stack.sawOpcode((DismantleBytecode)this, seen);
        TernaryPatcher.post(this.stack, seen);
        if (sawEnumCollectionCreation == null) return;
        if (this.stack.getStackDepth() <= 0) return;
        OpcodeStack.Item itm = this.stack.getStackItem(0);
        itm.setUserValue((Object)sawEnumCollectionCreation);
    }

    private boolean isEnum(int stackPos) throws ClassNotFoundException {
        if (this.stack.getStackDepth() > stackPos) {
            OpcodeStack.Item item = this.stack.getStackItem(stackPos);
            if (item.getSignature().charAt(0) != 'L') {
                return false;
            }
            JavaClass cls = item.getJavaClass();
            if (cls == null || !cls.isEnum()) {
                return false;
            }
            if (cls.getInterfaces().length == 0) {
                return true;
            }
        }
        return false;
    }

    private boolean isEnumCollection(int stackPos) {
        if (this.stack.getStackDepth() <= stackPos) {
            return false;
        }
        OpcodeStack.Item item = this.stack.getStackItem(stackPos);
        Boolean userValue = (Boolean)item.getUserValue();
        if (userValue != null) {
            return userValue;
        }
        String realClass = item.getSignature();
        if ("Ljava/util/EnumSet;".equals(realClass) || "Ljava/util/EnumMap;".equals(realClass)) {
            return true;
        }
        return !nonEnumCollections.contains(realClass);
    }

    private boolean alreadyReported(int stackPos) {
        if (this.stack.getStackDepth() > stackPos) {
            OpcodeStack.Item item = this.stack.getStackItem(stackPos);
            XField field = item.getXField();
            if (field == null) {
                return false;
            }
            String fieldName = field.getName();
            boolean checked = this.checkedFields.contains(fieldName);
            this.checkedFields.add(fieldName);
            return checked;
        }
        return false;
    }

    static {
        nonEnumCollections.add("Ljava/util/HashSet;");
        nonEnumCollections.add("Ljava/util/HashMap;");
        nonEnumCollections.add("Ljava/util/TreeMap;");
        nonEnumCollections.add("Ljava/util/ConcurrentHashMap");
        nonEnumCollections.add("Ljava/util/IdentityHashMap;");
        nonEnumCollections.add("Ljava/util/WeakHashMap;");
    }
}

