/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.RegisterUtils;
import com.mebigfatguy.fbcontrib.utils.TernaryPatcher;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.JavaClass;

@OpcodeStack.CustomUserValue
public class UseToArray
extends BytecodeScanningDetector {
    private JavaClass collectionClass;
    private ClassNotFoundException ex;
    private BugReporter bugReporter;
    private OpcodeStack stack;
    private Map<Integer, Object> userValues;

    public UseToArray(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        try {
            this.collectionClass = Repository.lookupClass((String)"java/util/Collection");
        }
        catch (ClassNotFoundException cnfe) {
            this.collectionClass = null;
            this.ex = cnfe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        if (this.collectionClass == null) {
            if (this.ex != null) {
                this.bugReporter.reportMissingClass(this.ex);
                this.ex = null;
            }
            return;
        }
        try {
            this.stack = new OpcodeStack();
            super.visitClassContext(classContext);
            Object var3_2 = null;
            this.stack = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.stack = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitCode(Code obj) {
        try {
            this.stack.resetForMethodEntry((DismantleBytecode)this);
            this.userValues = new HashMap<Integer, Object>();
            super.visitCode(obj);
            Object var3_2 = null;
            this.userValues = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.userValues = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sawOpcode(int seen) {
        int reg = -1;
        Object uValue = null;
        boolean sawAlias = false;
        boolean sawLoad = false;
        boolean sawNewArray = false;
        try {
            block25: {
                try {
                    OpcodeStack.Item itm;
                    this.stack.precomputation((DismantleBytecode)this);
                    if (seen == 185) {
                        OpcodeStack.Item itm2;
                        String methodName = this.getNameConstantOperand();
                        String signature = this.getSigConstantOperand();
                        if ("size".equals(methodName) && "()I".equals(signature)) {
                            OpcodeStack.Item itm3;
                            if (this.stack.getStackDepth() > 0 && (reg = this.isLocalCollection(itm3 = this.stack.getStackItem(0))) >= 0) {
                                sawAlias = true;
                            }
                            break block25;
                        }
                        if ("get".equals(methodName) && "(I)Ljava/lang/Object;".equals(signature)) {
                            OpcodeStack.Item itm4;
                            if (this.stack.getStackDepth() > 1 && (reg = this.isLocalCollection(itm4 = this.stack.getStackItem(1))) >= 0) {
                                sawAlias = true;
                            }
                            break block25;
                        }
                        if (("keySet".equals(methodName) || "values".equals(methodName) || "iterator".equals(methodName) || "next".equals(methodName)) && this.stack.getStackDepth() > 0 && (reg = this.isLocalCollection(itm2 = this.stack.getStackItem(0))) >= 0) {
                            sawAlias = true;
                        }
                        break block25;
                    }
                    if (seen == 54 || seen >= 59 && seen <= 62 || seen == 58 || seen >= 75 && seen <= 78) {
                        if (this.stack.getStackDepth() > 0) {
                            uValue = this.stack.getStackItem(0).getUserValue();
                            this.userValues.put(RegisterUtils.getStoreReg((DismantleBytecode)this, seen), uValue);
                        }
                        break block25;
                    }
                    if (seen == 21 || seen >= 26 && seen <= 29 || seen == 25 || seen >= 42 && seen <= 45) {
                        sawLoad = true;
                        break block25;
                    }
                    if (seen == 189) {
                        if (this.stack.getStackDepth() > 0) {
                            OpcodeStack.Item itm5 = this.stack.getStackItem(0);
                            uValue = itm5.getUserValue();
                            sawNewArray = true;
                        }
                        break block25;
                    }
                    if (seen == 162) {
                        if (this.stack.getStackDepth() <= 1) break block25;
                        OpcodeStack.Item itm1 = this.stack.getStackItem(1);
                        OpcodeStack.Item itm2 = this.stack.getStackItem(0);
                        reg = itm1.getRegisterNumber();
                        if (reg >= 0 && itm1.couldBeZero() && (uValue = itm2.getUserValue()) != null) {
                            this.userValues.put(reg, uValue);
                        }
                        break block25;
                    }
                    if (seen >= 79 && seen <= 86) {
                        if (this.stack.getStackDepth() <= 2) break block25;
                        OpcodeStack.Item arItem = this.stack.getStackItem(2);
                        OpcodeStack.Item idxItem = this.stack.getStackItem(1);
                        OpcodeStack.Item valueItem = this.stack.getStackItem(0);
                        reg = this.isLocalCollection(arItem);
                        if (reg >= 0 && idxItem.getUserValue() != null && valueItem.getUserValue() != null) {
                            this.bugReporter.reportBug(new BugInstance((Detector)this, "UTA_USE_TO_ARRAY", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                        }
                        break block25;
                    }
                    if (seen != 192 || this.stack.getStackDepth() <= 0 || !((uValue = (itm = this.stack.getStackItem(0)).getUserValue()) instanceof Integer)) break block25;
                    reg = (Integer)uValue;
                    sawAlias = true;
                }
                catch (ClassNotFoundException cnfe) {
                    this.bugReporter.reportMissingClass(cnfe);
                    Object var11_21 = null;
                    TernaryPatcher.pre(this.stack, seen);
                    this.stack.sawOpcode((DismantleBytecode)this, seen);
                    TernaryPatcher.post(this.stack, seen);
                    if (sawAlias) {
                        if (this.stack.getStackDepth() <= 0) return;
                        OpcodeStack.Item itm = this.stack.getStackItem(0);
                        itm.setUserValue((Object)reg);
                        return;
                    }
                    if (sawLoad) {
                        if (this.stack.getStackDepth() <= 0) return;
                        OpcodeStack.Item itm = this.stack.getStackItem(0);
                        reg = itm.getRegisterNumber();
                        if (reg < 0) return;
                        uValue = this.userValues.get(reg);
                        itm.setUserValue(uValue);
                        return;
                    }
                    if (!sawNewArray) return;
                    if (this.stack.getStackDepth() <= 0) return;
                    OpcodeStack.Item itm = this.stack.getStackItem(0);
                    itm.setUserValue(uValue);
                    return;
                }
            }
            Object var11_20 = null;
            TernaryPatcher.pre(this.stack, seen);
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            TernaryPatcher.post(this.stack, seen);
            if (sawAlias) {
                if (this.stack.getStackDepth() <= 0) return;
                OpcodeStack.Item itm = this.stack.getStackItem(0);
                itm.setUserValue((Object)reg);
                return;
            }
            if (sawLoad) {
                if (this.stack.getStackDepth() <= 0) return;
                OpcodeStack.Item itm = this.stack.getStackItem(0);
                reg = itm.getRegisterNumber();
                if (reg < 0) return;
                uValue = this.userValues.get(reg);
                itm.setUserValue(uValue);
                return;
            }
            if (!sawNewArray) return;
            if (this.stack.getStackDepth() <= 0) return;
            OpcodeStack.Item itm = this.stack.getStackItem(0);
            itm.setUserValue(uValue);
            return;
        }
        catch (Throwable throwable) {
            Object var11_22 = null;
            TernaryPatcher.pre(this.stack, seen);
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            TernaryPatcher.post(this.stack, seen);
            if (sawAlias) {
                if (this.stack.getStackDepth() <= 0) throw throwable;
                OpcodeStack.Item itm = this.stack.getStackItem(0);
                itm.setUserValue((Object)reg);
                throw throwable;
            }
            if (sawLoad) {
                if (this.stack.getStackDepth() <= 0) throw throwable;
                OpcodeStack.Item itm = this.stack.getStackItem(0);
                reg = itm.getRegisterNumber();
                if (reg < 0) throw throwable;
                uValue = this.userValues.get(reg);
                itm.setUserValue(uValue);
                throw throwable;
            }
            if (!sawNewArray) throw throwable;
            if (this.stack.getStackDepth() <= 0) throw throwable;
            OpcodeStack.Item itm = this.stack.getStackItem(0);
            itm.setUserValue(uValue);
            throw throwable;
        }
    }

    private int isLocalCollection(OpcodeStack.Item item) throws ClassNotFoundException {
        Integer aliasReg = (Integer)item.getUserValue();
        if (aliasReg != null) {
            return aliasReg;
        }
        int reg = item.getRegisterNumber();
        if (reg < 0) {
            return -1;
        }
        JavaClass cls = item.getJavaClass();
        if (cls != null && cls.implementationOf(this.collectionClass)) {
            return reg;
        }
        return -1;
    }
}

