/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.utils;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignatureUtils {
    public static boolean isInheritedMethod(JavaClass cls, String methodName, String signature) throws ClassNotFoundException {
        JavaClass[] infs = cls.getAllInterfaces();
        if (SignatureUtils.findInheritedMethod(infs, methodName, signature) != null) {
            return true;
        }
        JavaClass[] supers = cls.getSuperClasses();
        for (int i = 0; i < supers.length; ++i) {
            if (!"java.lang.Object".equals(supers[i].getClassName())) continue;
            supers[i] = null;
        }
        return SignatureUtils.findInheritedMethod(supers, methodName, signature) != null;
    }

    public static String getPackageName(String className) {
        int dotPos = className.lastIndexOf(46);
        if (dotPos < 0) {
            return "";
        }
        return className.substring(0, dotPos);
    }

    public static boolean similarPackages(String packName1, String packName2, int depth) {
        String s2;
        if (depth == 0) {
            return true;
        }
        packName1 = packName1.replace('/', '.');
        packName2 = packName2.replace('/', '.');
        int dot1 = packName1.indexOf(46);
        int dot2 = packName2.indexOf(46);
        if (dot1 < 0) {
            return dot2 < 0;
        }
        if (dot2 < 0) {
            return false;
        }
        String s1 = packName1.substring(0, dot1);
        if (!s1.equals(s2 = packName2.substring(0, dot2))) {
            return false;
        }
        return SignatureUtils.similarPackages(packName1.substring(dot1 + 1), packName2.substring(dot2 + 1), depth - 1);
    }

    public static String getTypeCodeSignature(int typeCode) {
        switch (typeCode) {
            case 4: {
                return "Z";
            }
            case 5: {
                return "C";
            }
            case 6: {
                return "F";
            }
            case 7: {
                return "D";
            }
            case 8: {
                return "B";
            }
            case 9: {
                return "S";
            }
            case 10: {
                return "I";
            }
            case 11: {
                return "L";
            }
        }
        return "Ljava/lang/Object;";
    }

    private static JavaClass findInheritedMethod(JavaClass[] classes, String methodName, String signature) {
        for (JavaClass cls : classes) {
            Method[] methods;
            if (cls == null) continue;
            for (Method m : methods = cls.getMethods()) {
                if (m.isPrivate() || !m.getName().equals(methodName) || !m.getSignature().equals(signature)) continue;
                return cls;
            }
        }
        return null;
    }

    public static Map<Integer, String> getParameterSignatures(Method m) {
        Type[] parms = m.getArgumentTypes();
        LinkedHashMap<Integer, String> parmSigs = new LinkedHashMap<Integer, String>();
        int slot = m.isStatic() ? 0 : 1;
        for (Type t : parms) {
            String signature = t.getSignature();
            parmSigs.put(slot, signature);
            slot += "J".equals(signature) || "D".equals(signature) ? 2 : 1;
        }
        return parmSigs;
    }
}

