/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.utils;

import edu.umd.cs.findbugs.OpcodeStack;
import java.util.ArrayList;
import java.util.List;

public class TernaryPatcher {
    private static List<Object> userValues = new ArrayList<Object>();
    private static boolean sawGOTO = false;

    private TernaryPatcher() {
    }

    public static void pre(OpcodeStack stack, int opcode) {
        if (!sawGOTO) {
            int depth;
            boolean bl = sawGOTO = opcode == 167 || opcode == 200;
            if (sawGOTO && (depth = stack.getStackDepth()) > 0) {
                userValues.clear();
                for (int i = 0; i < depth; ++i) {
                    OpcodeStack.Item item = stack.getStackItem(i);
                    userValues.add(item.getUserValue());
                }
            }
        }
    }

    public static void post(OpcodeStack stack, int opcode) {
        if (opcode != 167 && opcode != 200 && sawGOTO) {
            int depth = stack.getStackDepth();
            if (depth > 0) {
                for (int i = 0; i < depth; ++i) {
                    OpcodeStack.Item item;
                    if (userValues.size() <= i || (item = stack.getStackItem(i)).getUserValue() != null) continue;
                    item.setUserValue(userValues.get(i));
                }
            }
            userValues.clear();
            sawGOTO = false;
        }
    }
}

