/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.crypto;

import com.netapp.crypto.KeyStoreWrapperListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.crypto.SecretKey;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class KeyStoreWrapper {
    private final KeyStore keyStore;
    private final File keyStoreFile;
    private final char[] keyStorePassword;
    private final Set<KeyStoreWrapperListener> listeners = new HashSet<KeyStoreWrapperListener>();

    private KeyStoreWrapper(KeyStore keyStore, File keyStoreFile, char[] keyStorePassword) {
        this.keyStore = keyStore;
        this.keyStoreFile = keyStoreFile;
        this.keyStorePassword = (char[])keyStorePassword.clone();
    }

    public File getKeyStoreFile() {
        return this.keyStoreFile;
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public String getKeyStoreType() {
        return this.keyStore.getType();
    }

    public char[] getKeyStorePassword() {
        return (char[])this.keyStorePassword.clone();
    }

    public char[] getKeyPassword() {
        return (char[])this.keyStorePassword.clone();
    }

    public boolean addListener(KeyStoreWrapperListener listener) {
        return this.listeners.add(listener);
    }

    public boolean removeListener(KeyStoreWrapperListener listener) {
        return this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void saveKeyStore() throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        BufferedOutputStream keyStoreOutputStream = null;
        try {
            if (!this.keyStoreFile.getCanonicalFile().getParentFile().exists() && !this.keyStoreFile.getCanonicalFile().getParentFile().mkdirs()) {
                throw new IOException("Unable to make directory: " + this.keyStoreFile.getCanonicalFile().getParentFile());
            }
            keyStoreOutputStream = new BufferedOutputStream(new FileOutputStream(this.keyStoreFile));
            this.keyStore.store(keyStoreOutputStream, this.keyStorePassword);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(keyStoreOutputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)keyStoreOutputStream);
        for (KeyStoreWrapperListener listener : this.listeners) {
            listener.onSave(this);
        }
    }

    public synchronized Enumeration<String> aliases() throws KeyStoreException {
        return this.keyStore.aliases();
    }

    public synchronized Key getKey(String alias) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        return this.keyStore.getKey(alias, this.getKeyPassword());
    }

    public synchronized Certificate getCertificate(String alias) throws KeyStoreException {
        return this.keyStore.getCertificate(alias);
    }

    public synchronized void setKeyEntry(String alias, SecretKey key) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        this.keyStore.setKeyEntry(alias, key, this.getKeyPassword(), null);
        this.saveKeyStore();
    }

    public synchronized void setKeyEntry(String alias, PrivateKey key, X509Certificate certificate) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        this.keyStore.setKeyEntry(alias, key, this.getKeyPassword(), new Certificate[]{certificate});
        this.saveKeyStore();
    }

    public synchronized void setCertificateEntry(String alias, X509Certificate certificate) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        this.keyStore.setCertificateEntry(alias, certificate);
        this.saveKeyStore();
    }

    public synchronized void deleteEntry(String alias) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        this.keyStore.deleteEntry(alias);
        this.saveKeyStore();
    }

    public synchronized boolean hasPrivateKey() throws KeyStoreException {
        Enumeration<String> e = this.keyStore.aliases();
        while (e.hasMoreElements()) {
            String alias = e.nextElement();
            if (!this.keyStore.entryInstanceOf(alias, KeyStore.PrivateKeyEntry.class)) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean hasCertificate() throws KeyStoreException {
        Enumeration<String> e = this.keyStore.aliases();
        while (e.hasMoreElements()) {
            String alias = e.nextElement();
            if (!this.keyStore.entryInstanceOf(alias, KeyStore.TrustedCertificateEntry.class)) continue;
            return true;
        }
        return false;
    }

    public static KeyStoreWrapper createWrapper(File keyStoreFile) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        return KeyStoreWrapper.createWrapper(keyStoreFile, "jceks", new File(keyStoreFile.getAbsolutePath() + ".password"));
    }

    public static KeyStoreWrapper createWrapper(File keyStoreFile, String keyStoreType, File keyStorePasswordFile) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        char[] keyStorePassword = KeyStoreWrapper.readKeyStorePassword(keyStorePasswordFile);
        return KeyStoreWrapper.createWrapper(keyStoreFile, keyStoreType, keyStorePassword);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStoreWrapper createWrapper(File keyStoreFile, String keyStoreType, char[] keyStorePassword) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStoreWrapper keyStoreWrapper;
        KeyStore keyStore = KeyStore.getInstance(keyStoreType);
        BufferedInputStream keyStoreInputStream = null;
        try {
            KeyStoreWrapper wrapper;
            boolean existingKeyStore = keyStoreFile.exists();
            if (existingKeyStore) {
                keyStoreInputStream = new BufferedInputStream(new FileInputStream(keyStoreFile));
            }
            keyStore.load(keyStoreInputStream, keyStorePassword);
            keyStoreWrapper = wrapper = new KeyStoreWrapper(keyStore, keyStoreFile, keyStorePassword);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(keyStoreInputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)keyStoreInputStream);
        return keyStoreWrapper;
    }

    private static char[] readKeyStorePassword(File keyStorePasswordFile) throws IOException {
        if (keyStorePasswordFile.exists()) {
            return FileUtils.readFileToString((File)keyStorePasswordFile).trim().toCharArray();
        }
        return new char[]{'c', 'h', 'a', 'n', 'g', 'e', 'm', 'e'};
    }
}

