/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.crypto;

import com.netapp.crypto.Aes128CbcPkcs5PaddingCipherDelegate;
import com.netapp.crypto.CryptoException;
import com.netapp.crypto.KeyRotator;
import com.netapp.crypto.KeyStoreWrapper;
import com.netapp.crypto.Sha1PrngSecureRandomFactory;
import com.netapp.crypto.SymmetricCipherDelegate;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import net.jcip.annotations.ThreadSafe;
import org.apache.commons.codec.binary.Base64InputStream;
import org.apache.commons.codec.binary.Base64OutputStream;
import org.apache.commons.io.IOUtils;

@ThreadSafe
public class SymmetricCipherFacade {
    public static final String DEFAULT_CHARSET = "UTF-8";
    private final Map<Integer, SymmetricCipherDelegate> cipherDelegates;
    private final SymmetricCipherDelegate encryptionCipherDelegate;
    private final Map<SymmetricCipherDelegate, KeyRotator> keyRotators;
    private Callable<KeyStoreWrapper> keyStoreWrapperProvider;

    public SymmetricCipherFacade(KeyStoreWrapper keyStoreWrapper) {
        this(new SingletonCallable<KeyStoreWrapper>(keyStoreWrapper));
    }

    public SymmetricCipherFacade(Callable<KeyStoreWrapper> keyStoreWrapperProvider) {
        if (keyStoreWrapperProvider == null) {
            throw new NullPointerException("keyStoreWrapperProvider");
        }
        this.keyStoreWrapperProvider = keyStoreWrapperProvider;
        this.cipherDelegates = new HashMap<Integer, SymmetricCipherDelegate>();
        this.keyRotators = new HashMap<SymmetricCipherDelegate, KeyRotator>();
        List<SymmetricCipherDelegate> cipherDelegateLists = this.createCipherDelegates(new Sha1PrngSecureRandomFactory());
        this.encryptionCipherDelegate = cipherDelegateLists.get(cipherDelegateLists.size() - 1);
        for (SymmetricCipherDelegate cipherDelegate : cipherDelegateLists) {
            this.cipherDelegates.put(cipherDelegate.getId(), cipherDelegate);
        }
    }

    private List<SymmetricCipherDelegate> createCipherDelegates(Callable<SecureRandom> secureRandomFactory) {
        ArrayList<SymmetricCipherDelegate> cipherDelegateList = new ArrayList<SymmetricCipherDelegate>();
        cipherDelegateList.add(new Aes128CbcPkcs5PaddingCipherDelegate(secureRandomFactory));
        return cipherDelegateList;
    }

    private synchronized KeyRotator getKeyRotator(SymmetricCipherDelegate cipherDelegate) {
        KeyRotator keyRotator = this.keyRotators.get(cipherDelegate);
        if (keyRotator == null) {
            try {
                keyRotator = new KeyRotator(this.keyStoreWrapperProvider.call(), cipherDelegate);
                this.keyRotators.put(cipherDelegate, keyRotator);
            }
            catch (Exception e) {
                throw new CryptoException(e);
            }
        }
        return keyRotator;
    }

    public String encrypt(String plainText) {
        return this.encrypt(plainText, DEFAULT_CHARSET);
    }

    public String encrypt(String plainText, String charsetName) {
        if (plainText == null) {
            return null;
        }
        try {
            return new String(this.encrypt(plainText.getBytes(charsetName)), charsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw new CryptoException(e);
        }
    }

    public byte[] encrypt(byte[] plainText) {
        if (plainText == null) {
            return null;
        }
        try {
            KeyRotator.KeyEntry encryptionKeyEntry = this.getKeyRotator(this.encryptionCipherDelegate).getCurrentKey();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream((OutputStream)new Base64OutputStream((OutputStream)baos, true, -1, null));
            dos.writeInt(this.encryptionCipherDelegate.getId());
            dos.writeLong(encryptionKeyEntry.getIndex());
            dos.write(this.encryptionCipherDelegate.encrypt(encryptionKeyEntry.getKey(), plainText));
            dos.close();
            return baos.toByteArray();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
    }

    public String decrypt(String cipherText) {
        return this.decrypt(cipherText, DEFAULT_CHARSET);
    }

    public String decrypt(String cipherText, String charsetName) {
        if (cipherText == null) {
            return null;
        }
        try {
            return new String(this.decrypt(cipherText.getBytes(charsetName)), charsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw new CryptoException(e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] decrypt(byte[] cipherText) {
        byte[] byArray;
        if (cipherText == null) {
            return null;
        }
        DataInputStream dis = null;
        try {
            byte[] plainText;
            dis = new DataInputStream((InputStream)new Base64InputStream((InputStream)new ByteArrayInputStream(cipherText)));
            int cipherDelegateId = dis.readInt();
            SymmetricCipherDelegate decryptionCipherDelegate = this.cipherDelegates.get(cipherDelegateId);
            if (decryptionCipherDelegate == null) {
                throw new CryptoException(String.format("Unknown cipher delegate %d.  Ciphertext either was not created with SymmetricCipherFacade, or was created with a later version of SymmetricCipherFacade.", cipherDelegateId));
            }
            long keyIndex = dis.readLong();
            KeyRotator.KeyEntry decryptionKeyEntry = this.getKeyRotator(decryptionCipherDelegate).getKey(keyIndex);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)dis, (OutputStream)baos);
            byte[] encryptedData = baos.toByteArray();
            byArray = plainText = decryptionCipherDelegate.decrypt(decryptionKeyEntry.getKey(), encryptedData);
        }
        catch (RuntimeException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new CryptoException(e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(dis);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)dis);
        return byArray;
    }

    public void generateNewKey() throws NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException {
        this.getKeyRotator(this.encryptionCipherDelegate).generateNextKey();
    }

    private static class SingletonCallable<T>
    implements Callable<T> {
        private final T singleton;

        public SingletonCallable(T singleton) {
            this.singleton = singleton;
        }

        @Override
        public T call() throws Exception {
            return this.singleton;
        }
    }
}

