/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.impl;

import java.lang.invoke.MethodHandles;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.ObjIntConsumer;
import java.util.function.Predicate;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.util.ConcatIterator;
import org.infinispan.commons.util.FlattenSpliterator;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IteratorMapper;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.impl.AbstractInternalDataContainer;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.notifications.Listener;
import org.infinispan.remoting.transport.Address;

@Listener
public class DefaultSegmentedDataContainer<K, V>
extends AbstractInternalDataContainer<K, V> {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private static final boolean trace = log.isTraceEnabled();
    public final AtomicReferenceArray<ConcurrentMap<K, InternalCacheEntry<K, V>>> maps;
    protected Address localNode;

    public DefaultSegmentedDataContainer(int numSegments) {
        this.maps = new AtomicReferenceArray(numSegments);
    }

    @Override
    @Start
    public void start() {
        this.localNode = this.cache.getCacheManager().getAddress();
        this.keyPartitioner = this.cache.getAdvancedCache().getComponentRegistry().getComponent(KeyPartitioner.class);
        for (int i = 0; i < this.maps.length(); ++i) {
            this.maps.set(i, new ConcurrentHashMap());
        }
    }

    @Stop(priority=999)
    public void stop() {
        this.cache.removeListener(this);
        for (int i = 0; i < this.maps.length(); ++i) {
            this.maps.set(0, null);
        }
    }

    @Override
    protected int getSegmentForKey(Object key) {
        return this.keyPartitioner.getSegment(key);
    }

    @Override
    protected ConcurrentMap<K, InternalCacheEntry<K, V>> getMapForSegment(int segment) {
        return this.maps.get(segment);
    }

    @Override
    public Iterator<InternalCacheEntry<K, V>> iterator(IntSet segments) {
        return new AbstractInternalDataContainer.EntryIterator(this.iteratorIncludingExpired(segments));
    }

    @Override
    public Iterator<InternalCacheEntry<K, V>> iterator() {
        return new AbstractInternalDataContainer.EntryIterator(this.iteratorIncludingExpired());
    }

    @Override
    public Spliterator<InternalCacheEntry<K, V>> spliterator(IntSet segments) {
        return this.filterExpiredEntries(this.spliteratorIncludingExpired(segments));
    }

    @Override
    public Spliterator<InternalCacheEntry<K, V>> spliterator() {
        return this.filterExpiredEntries(this.spliteratorIncludingExpired());
    }

    @Override
    public Iterator<InternalCacheEntry<K, V>> iteratorIncludingExpired(IntSet segments) {
        ArrayList valueIterables = new ArrayList(segments.size());
        segments.forEach(s -> {
            ConcurrentMap<K, InternalCacheEntry<K, V>> map = this.maps.get(s);
            if (map != null) {
                valueIterables.add(map.values());
            }
        });
        return new ConcatIterator(valueIterables);
    }

    @Override
    public Iterator<InternalCacheEntry<K, V>> iteratorIncludingExpired() {
        ArrayList valueIterables = new ArrayList(this.maps.length() + 1);
        for (int i = 0; i < this.maps.length(); ++i) {
            ConcurrentMap<K, InternalCacheEntry<K, V>> map = this.maps.get(i);
            if (map == null) continue;
            valueIterables.add(map.values());
        }
        return new ConcatIterator(valueIterables);
    }

    @Override
    public Spliterator<InternalCacheEntry<K, V>> spliteratorIncludingExpired(IntSet segments) {
        int[] segmentArray = segments.toIntArray();
        return new FlattenSpliterator(i -> {
            ConcurrentMap<K, InternalCacheEntry<K, V>> map = this.maps.get(segmentArray[i]);
            if (map == null) {
                return Collections.emptyList();
            }
            return map.values();
        }, segmentArray.length, 4353);
    }

    @Override
    public Spliterator<InternalCacheEntry<K, V>> spliteratorIncludingExpired() {
        return new FlattenSpliterator(i -> {
            ConcurrentMap<K, InternalCacheEntry<K, V>> map = this.maps.get(i);
            if (map == null) {
                return Collections.emptyList();
            }
            return map.values();
        }, this.maps.length(), 4353);
    }

    @Override
    public int sizeIncludingExpired(IntSet segment) {
        int size = 0;
        PrimitiveIterator.OfInt iter = segment.iterator();
        while (iter.hasNext()) {
            ConcurrentMap<K, InternalCacheEntry<K, V>> map = this.maps.get(iter.nextInt());
            if ((size += map != null ? map.size() : 0) >= 0) continue;
            return Integer.MAX_VALUE;
        }
        return size;
    }

    @Override
    public int sizeIncludingExpired() {
        int size = 0;
        for (int i = 0; i < this.maps.length(); ++i) {
            ConcurrentMap<K, InternalCacheEntry<K, V>> map = this.maps.get(i);
            if (map == null || (size += map.size()) >= 0) continue;
            return Integer.MAX_VALUE;
        }
        return size;
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.maps.length(); ++i) {
            ConcurrentMap<K, InternalCacheEntry<K, V>> map = this.maps.get(i);
            if (map == null) continue;
            map.clear();
        }
    }

    @Override
    public void forEach(IntSet segments, Consumer<? super InternalCacheEntry<K, V>> action) {
        Predicate expiredPredicate = this.expiredIterationPredicate(this.timeService.wallClockTime());
        BiConsumer<Object, InternalCacheEntry> biConsumer = (k, ice) -> {
            if (expiredPredicate.test(ice)) {
                action.accept((Object)ice);
            }
        };
        segments.forEach(s -> {
            ConcurrentMap<K, InternalCacheEntry<K, V>> map = this.maps.get(s);
            if (map != null) {
                map.forEach(biConsumer);
            }
        });
    }

    @Override
    public void forEachIncludingExpired(ObjIntConsumer<? super InternalCacheEntry<K, V>> action) {
        for (int i = 0; i < this.maps.length(); ++i) {
            ConcurrentMap<Object, InternalCacheEntry<Object, InternalCacheEntry>> map = this.maps.get(i);
            if (map == null) continue;
            int segment = i;
            map.forEach((? super K k, ? super V ice) -> action.accept((Object)ice, segment));
        }
    }

    @Override
    public void addSegments(IntSet segments) {
        if (trace) {
            log.tracef("Ensuring segments %s are started", (Object)segments);
        }
        segments.forEach(this::startNewMap);
    }

    @Override
    public void removeSegments(IntSet segments) {
        if (trace) {
            log.tracef("Removing segments: %s from container", (Object)segments);
        }
        segments.forEach(s -> {
            ConcurrentMap map = this.maps.getAndSet(s, null);
            if (map != null && !map.isEmpty()) {
                this.listeners.forEach(c -> c.accept(map.values()));
            }
        });
    }

    @Override
    public Set<K> keySet() {
        return new AbstractSet<K>(){

            @Override
            public boolean contains(Object o) {
                return DefaultSegmentedDataContainer.this.containsKey(o);
            }

            @Override
            public Iterator<K> iterator() {
                return new IteratorMapper(DefaultSegmentedDataContainer.this.iteratorIncludingExpired(), Map.Entry::getKey);
            }

            @Override
            public int size() {
                return DefaultSegmentedDataContainer.this.size();
            }

            @Override
            public Spliterator<K> spliterator() {
                return Spliterators.spliterator(this, 4353);
            }
        };
    }

    private void startNewMap(int segment) {
        if (this.maps.get(segment) == null) {
            this.maps.compareAndSet(segment, null, new ConcurrentHashMap());
        }
    }
}

