/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.common.concurrent;

import java.util.concurrent.Semaphore;
import net.jcip.annotations.GuardedBy;

public final class AdjustableSemaphore
extends Semaphore {
    @GuardedBy(value="this")
    private int maxPermits;

    public AdjustableSemaphore(int initialMaxPermits, boolean fair) {
        super(initialMaxPermits, fair);
        this.setMaxPermitsInternal(initialMaxPermits);
    }

    public AdjustableSemaphore(int initialMaxPermits) {
        super(initialMaxPermits);
        this.setMaxPermitsInternal(initialMaxPermits);
    }

    public synchronized int getMaxPermits() {
        return this.maxPermits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxPermits(int newMax) {
        if (newMax <= 0) {
            throw new IllegalArgumentException(String.format("maxPermits must be > 0, %d is not a valid value", newMax));
        }
        AdjustableSemaphore adjustableSemaphore = this;
        synchronized (adjustableSemaphore) {
            int oldMax = this.getMaxPermits();
            if (newMax == oldMax) {
                return;
            }
            if (newMax > oldMax) {
                this.release(newMax - oldMax);
            } else {
                this.reducePermits(oldMax - newMax);
            }
            this.setMaxPermitsInternal(newMax);
        }
    }

    private synchronized void setMaxPermitsInternal(int newMax) {
        this.maxPermits = newMax;
    }
}

