/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.common.encryption;

import com.netapp.common.MsgKey;
import com.netapp.common.encryption.EncryptionException;
import com.netapp.common.logging.MessageKey;
import com.netapp.common.logging.NALogger;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class Encryption {
    private static final NALogger LOGGER = NALogger.getLogger(Encryption.class);
    private static final String ALGORITHM_X509 = "X.509";

    protected Encryption() {
    }

    public static byte[] encrypt(byte[] toEncrypt, Key encryptionKey, String algorithm) throws EncryptionException {
        try {
            Cipher cipher = Encryption.getCipher(encryptionKey, algorithm, 1);
            return cipher.doFinal(toEncrypt);
        }
        catch (IllegalBlockSizeException e) {
            throw new EncryptionException(e);
        }
        catch (BadPaddingException e) {
            throw new EncryptionException(e);
        }
    }

    public static byte[] decrypt(byte[] toDecrypt, Key deccryptionKey, String algorithm) throws EncryptionException {
        try {
            Cipher cipher = Encryption.getCipher(deccryptionKey, algorithm, 2);
            return cipher.doFinal(toDecrypt);
        }
        catch (IllegalBlockSizeException e) {
            throw new EncryptionException(e);
        }
        catch (BadPaddingException e) {
            throw new EncryptionException(e);
        }
    }

    public static PrivateKey getPrivateKeyFromFile(String privateKeyFile, String algorithm) throws EncryptionException {
        try {
            byte[] privateKeyBytes = Encryption.readFile(privateKeyFile);
            KeyFactory keyFactory = KeyFactory.getInstance(Encryption.getAlgorithmFromTransformation(algorithm));
            PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(privateKeyBytes);
            return keyFactory.generatePrivate(privateKeySpec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new EncryptionException(e);
        }
        catch (IOException e) {
            throw new EncryptionException(e);
        }
        catch (InvalidKeySpecException e) {
            throw new EncryptionException(e);
        }
    }

    public static PublicKey getPublicKeyFromFile(String publicKeyFile) throws EncryptionException {
        try {
            InputStream stream = Encryption.getFileInputStream(publicKeyFile);
            CertificateFactory factory = CertificateFactory.getInstance(ALGORITHM_X509);
            X509Certificate cert = (X509Certificate)factory.generateCertificate(stream);
            stream.close();
            return cert.getPublicKey();
        }
        catch (FileNotFoundException e) {
            throw new EncryptionException(e);
        }
        catch (CertificateException e) {
            throw new EncryptionException(e);
        }
        catch (IOException e) {
            throw new EncryptionException(e);
        }
    }

    public static Cipher getCipher(Key cipherKey, String algorithm, int cipherMode) throws EncryptionException {
        try {
            Cipher cipher = Cipher.getInstance(algorithm);
            cipher.init(cipherMode, cipherKey);
            return cipher;
        }
        catch (NoSuchAlgorithmException e) {
            throw new EncryptionException(e);
        }
        catch (NoSuchPaddingException e) {
            throw new EncryptionException(e);
        }
        catch (InvalidKeyException e) {
            throw new EncryptionException(e);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static byte[] readFile(String keyFile) throws IOException {
        void var4_6;
        File file = new File(keyFile);
        long length = -1L;
        Object var4_3 = null;
        if (!file.exists() && !file.isFile()) {
            URL url = ClassLoader.getSystemResource(keyFile);
            if (null == url) throw new FileNotFoundException(LOGGER.error((MessageKey)MsgKey.ENCRYPTION_ERROR_FILE_NOT_FOUND, keyFile));
            URLConnection connection = url.openConnection();
            length = connection.getContentLength();
            InputStream inputStream = connection.getInputStream();
            return Encryption.readFileFromInputStream((InputStream)var4_6, length);
        } else {
            length = file.length();
            FileInputStream fileInputStream = new FileInputStream(file.getPath());
        }
        return Encryption.readFileFromInputStream((InputStream)var4_6, length);
    }

    protected static byte[] readFileFromInputStream(InputStream stream, long length) {
        ByteArrayOutputStream contents = new ByteArrayOutputStream();
        byte[] buffer = new byte[(int)length];
        int read = 0;
        try {
            while ((long)read < length) {
                int inputLength = stream.read(buffer, read, buffer.length - read);
                contents.write(buffer, read, inputLength);
                read += inputLength;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return contents.toByteArray();
    }

    protected static InputStream getFileInputStream(String filepath) throws IOException {
        File file = new File(filepath);
        if (!file.exists() && !file.isFile()) {
            URL url = ClassLoader.getSystemResource(filepath);
            if (null == url) {
                url = Thread.currentThread().getContextClassLoader().getResource(filepath);
            }
            if (null != url) {
                return url.openStream();
            }
            throw new FileNotFoundException(LOGGER.error((MessageKey)MsgKey.ENCRYPTION_ERROR_FILE_NOT_FOUND, filepath));
        }
        return new FileInputStream(file);
    }

    public static String getAlgorithmFromTransformation(String transformation) {
        int index = transformation.indexOf("/");
        if (-1 != index) {
            transformation = transformation.substring(0, index);
        }
        return transformation;
    }
}

