/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.common.encryption;

import com.netapp.common.encryption.Encryption;
import com.netapp.common.encryption.EncryptionException;
import java.nio.charset.Charset;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.SecretKeySpec;

public class SymmetricEncryption {
    protected SymmetricEncryption() {
    }

    public static byte[] encrypt(String algorithm, byte[] secret, String encrypt) throws EncryptionException {
        try {
            Cipher cipher = SymmetricEncryption.getCipher(algorithm, secret, 1);
            return cipher.doFinal(encrypt.getBytes(Charset.defaultCharset()));
        }
        catch (IllegalBlockSizeException e) {
            throw new EncryptionException(e);
        }
        catch (BadPaddingException e) {
            throw new EncryptionException(e);
        }
    }

    public static String decrypt(String algorithm, byte[] secret, byte[] decrypt) throws EncryptionException {
        try {
            Cipher cipher = SymmetricEncryption.getCipher(algorithm, secret, 2);
            return new String(cipher.doFinal(decrypt), Charset.defaultCharset());
        }
        catch (IllegalBlockSizeException e) {
            throw new EncryptionException(e);
        }
        catch (BadPaddingException e) {
            throw new EncryptionException(e);
        }
    }

    public static Cipher getCipher(String algorithm, byte[] secret, int cipherMode) throws EncryptionException {
        SecretKeySpec key = new SecretKeySpec(secret, algorithm);
        return Encryption.getCipher(key, algorithm, cipherMode);
    }
}

