/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.common.graph;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.netapp.common.graph.DepthFirstPreorderIterator;
import com.netapp.common.graph.DisplayGraph;
import com.netapp.common.graph.NodeVisitor;
import com.netapp.common.graph.ResultProvidingNodeVisitor;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class Graph<T>
implements Iterable<T>,
Serializable {
    private Set<T> nodes;
    private Multimap<T, T> edges;

    public Graph() {
        this.nodes = new HashSet<T>();
        this.edges = HashMultimap.create();
    }

    public Graph(Graph<T> other) {
        this.nodes = new HashSet<T>(other.nodes);
        this.edges = HashMultimap.create(other.edges);
    }

    private Graph(Set<T> nodes, Multimap<T, T> edges) {
        this.nodes = nodes;
        this.edges = edges;
    }

    public static <T> Graph<T> create() {
        return new Graph<T>();
    }

    public Set<Edge<T>> getEdges() {
        HashSet<Edge<T>> edgeSet = new HashSet<Edge<T>>();
        for (Map.Entry edge : this.edges.entries()) {
            Object src = edge.getKey();
            Object dest = edge.getValue();
            edgeSet.add(new Edge(src, dest));
        }
        return edgeSet;
    }

    public Set<T> getSuccessors(T node) {
        return ImmutableSet.copyOf((Collection)this.edges.get(node));
    }

    public Set<T> getPredecessors(T node) {
        HashSet predecessors = new HashSet();
        for (Map.Entry edge : this.edges.entries()) {
            Object src = edge.getKey();
            Object dest = edge.getValue();
            if (!node.equals(dest)) continue;
            predecessors.add(src);
        }
        return Collections.unmodifiableSet(predecessors);
    }

    public Set<T> getDescendants(T node) {
        HashSet descendants = Sets.newHashSet();
        for (T successor : this.getSuccessors(node)) {
            descendants.addAll(Sets.newHashSet(this.depthFirstPreorderIterator(successor)));
        }
        return descendants;
    }

    public Set<T> getAncestors(T node) {
        return this.reverse().getDescendants(node);
    }

    public void addEdge(T src, T dest) {
        this.addEdges(src, dest);
    }

    public void addEdges(T src, T ... dests) {
        this.addNode(src);
        for (T dest : dests) {
            this.addNode(dest);
            this.edges.put(src, dest);
        }
    }

    public Graph<T> withEdge(T src, T dest) {
        return this.withEdges(src, dest);
    }

    public Graph<T> withEdges(T src, T ... dests) {
        this.addEdges(src, dests);
        return this;
    }

    public void addNode(T node) {
        this.nodes.add(node);
    }

    public Graph<T> withNode(T node) {
        this.addNode(node);
        return this;
    }

    @Override
    public Iterator<T> iterator() {
        return this.getNodes().iterator();
    }

    public Set<T> getNodes() {
        return Collections.unmodifiableSet(this.nodes);
    }

    public Set<T> getSources() {
        return this.reverse().getSinks();
    }

    public Set<T> getSinks() {
        return Sets.difference(this.nodes, (Set)this.edges.keySet());
    }

    public void removeNode(T node) {
        this.nodes.remove(node);
        this.edges.removeAll(node);
        Iterator i = this.edges.entries().iterator();
        while (i.hasNext()) {
            Map.Entry edge = (Map.Entry)i.next();
            Object dest = edge.getValue();
            if (!node.equals(dest)) continue;
            i.remove();
        }
    }

    public void removeEdge(T src, T dest) {
        Iterator i = this.edges.get(src).iterator();
        while (i.hasNext()) {
            if (!i.next().equals(dest)) continue;
            i.remove();
        }
    }

    public void replace(T orig, T replacement) {
        for (T successor : this.getSuccessors(orig)) {
            this.addEdge(replacement, successor);
        }
        for (T predecessor : this.getPredecessors(orig)) {
            this.addEdge(predecessor, replacement);
        }
        this.removeNode(orig);
    }

    public Graph<T> reverse() {
        HashMultimap reverseEdges = HashMultimap.create();
        Multimaps.invertFrom(this.edges, (Multimap)reverseEdges);
        return new Graph<T>(new HashSet<T>(this.nodes), reverseEdges);
    }

    public boolean pathExists(T source, T dest) {
        if (source.equals(dest)) {
            return true;
        }
        Iterator<T> i = this.depthFirstPreorderIterator(source);
        while (i.hasNext()) {
            if (!dest.equals(i.next())) continue;
            return true;
        }
        return false;
    }

    public Iterator<T> depthFirstPreorderIterator(T startNode) {
        return new DepthFirstPreorderIterator<T>(startNode, this);
    }

    public void depthFirstVisit(T startNode, NodeVisitor<T> visitor) {
        this.depthFirstVisitHelper(startNode, visitor, new HashSet());
    }

    private void depthFirstVisitHelper(T node, NodeVisitor<T> visitor, Set<T> nodesVisited) {
        if (nodesVisited.contains(node)) {
            return;
        }
        nodesVisited.add(node);
        if (visitor.preVisit(node)) {
            for (T child : this.getSuccessors(node)) {
                this.depthFirstVisitHelper(child, visitor, nodesVisited);
            }
            visitor.postVisit(node);
        }
    }

    public List<T> topologicalSort() {
        final HashSet visited = new HashSet(this.nodes.size());
        final ArrayDeque result = new ArrayDeque(this.nodes.size());
        for (T source : this.getSources()) {
            this.depthFirstVisit(source, new NodeVisitor<T>(){

                @Override
                public boolean preVisit(T node) {
                    boolean alreadyVisited = visited.contains(node);
                    visited.add(node);
                    return !alreadyVisited;
                }

                @Override
                public void postVisit(T node) {
                    result.addFirst(node);
                }
            });
        }
        return ImmutableList.copyOf(result);
    }

    public <R> R resultProvidingDepthFirstVisit(T startNode, ResultProvidingNodeVisitor<T, R> visitor) {
        return this.resultProvidingDepthFirstVisitHelper(startNode, visitor, new HashMap());
    }

    private <R> R resultProvidingDepthFirstVisitHelper(T node, ResultProvidingNodeVisitor<T, R> visitor, Map<T, R> nodesVisited) {
        if (nodesVisited.containsKey(node)) {
            return nodesVisited.get(node);
        }
        visitor.preVisit(node);
        HashSet<R> successorResults = new HashSet<R>();
        for (T child : this.getSuccessors(node)) {
            successorResults.add(this.resultProvidingDepthFirstVisitHelper(child, visitor, nodesVisited));
        }
        R result = visitor.postVisit(node, successorResults);
        nodesVisited.put(node, result);
        return result;
    }

    public <S> Graph<S> apply(Function<T, S> function) {
        HashMap<T, Object> nodeMap = new HashMap<T, Object>();
        Graph<Object> transformedGraph = new Graph<Object>();
        for (T node : this.nodes) {
            Object transformedNode = function.apply(node);
            nodeMap.put(node, transformedNode);
            transformedGraph.addNode(transformedNode);
        }
        for (Map.Entry edge : this.edges.entries()) {
            Object src = edge.getKey();
            Object dest = edge.getValue();
            transformedGraph.addEdge(nodeMap.get(src), nodeMap.get(dest));
        }
        return transformedGraph;
    }

    public void union(Graph<T> other) {
        this.nodes.addAll(other.nodes);
        this.edges.putAll(other.edges);
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.nodes).append(this.edges).toHashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Graph)) {
            return false;
        }
        Graph that = (Graph)obj;
        return new EqualsBuilder().append(this.nodes, that.nodes).append(this.edges, that.edges).isEquals();
    }

    public String toString() {
        return Joiner.on((String)"\n").join(this.getEdges());
    }

    public static <T> Graph<T> flatten(Graph<Graph<T>> graph) {
        Graph<Graph<T>> result = new Graph<Graph<T>>();
        for (Graph<Graph<T>> subGraph : graph.getNodes()) {
            for (Graph<T> graph2 : subGraph.getNodes()) {
                result.addNode(graph2);
            }
            for (Map.Entry entry : subGraph.edges.entries()) {
                result.addEdge((Graph<T>)entry.getKey(), (Graph<T>)entry.getValue());
            }
            for (Graph<Object> graph3 : graph.getPredecessors(subGraph)) {
                for (Object predecessorSubGraphSink : graph3.getSinks()) {
                    for (Graph<T> subGraphSource : subGraph.getSources()) {
                        result.addEdge((Graph<T>)predecessorSubGraphSink, subGraphSource);
                    }
                }
            }
        }
        return result;
    }

    public String toGraphviz(String graphName) {
        return DisplayGraph.fromGraph(graphName, this).toGraphviz();
    }

    public static class Edge<T>
    implements Serializable {
        private T src;
        private T dest;

        private Edge(T src, T dest) {
            this.src = src;
            this.dest = dest;
        }

        public T getSource() {
            return this.src;
        }

        public T getSrc() {
            return this.src;
        }

        public T getDest() {
            return this.dest;
        }

        public String toString() {
            return String.format("%s ==> %s", this.src, this.dest);
        }
    }
}

