/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.common.graph;

import com.netapp.common.graph.Graph;
import com.netapp.common.graph.HierarchicalObject;
import com.netapp.common.util.NoOpTransformer;
import com.netapp.common.util.Transformer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class HierarchicalObjectGraphFactory {
    public <S extends HierarchicalObject<S>, G extends Graph<S>> void buildGraph(G graph, S entryNode, S exitNode, Set<? extends S> rootHierarchicalObjects) {
        this.buildGraph(graph, entryNode, exitNode, rootHierarchicalObjects, new NoOpTransformer());
    }

    public <S extends HierarchicalObject<S>, T, G extends Graph<T>> void buildGraph(G graph, T entryNode, T exitNode, Set<? extends S> rootHierarchicalObjects, Transformer<S, T> nodeTransformer) {
        this.buildGraphHelper(graph, nodeTransformer, entryNode, rootHierarchicalObjects, new HashMap(), exitNode);
    }

    private <S extends HierarchicalObject<S>, T> void buildGraphHelper(Graph<T> graph, Transformer<S, T> nodeTransformer, T predecessorNode, Set<? extends S> hierarchicalObjects, Map<S, T> builtNodes, T exitNode) {
        for (HierarchicalObject hierarchicalObject : hierarchicalObjects) {
            T node = builtNodes.get(hierarchicalObject);
            if (node == null) {
                node = nodeTransformer.transform(hierarchicalObject);
                builtNodes.put(hierarchicalObject, node);
            }
            graph.addEdge(predecessorNode, node);
            this.buildGraphHelper(graph, nodeTransformer, node, hierarchicalObject.getSuccessors(), builtNodes, exitNode);
            if (!hierarchicalObject.getSuccessors().isEmpty() || exitNode == null) continue;
            graph.addEdge(node, exitNode);
        }
    }
}

