/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.common.timing;

import com.netapp.common.logging.LogLevel;
import com.netapp.common.logging.NALogger;
import com.netapp.common.util.UncheckedCallable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.concurrent.Callable;
import org.apache.commons.lang.time.DurationFormatUtils;

public class StopWatch
implements Serializable {
    private static final String ROOT_LOGGER_NAME = "stopwatch";
    private static final NALogger ROOT_LOGGER = NALogger.getLogger("stopwatch");
    private transient NALogger logger = ROOT_LOGGER;
    private String category;
    private String tagFormat;
    private Object[] tagArgs;
    private long startTime = -1L;
    private long endTime = -1L;

    public StopWatch() {
    }

    public StopWatch(long startTime, long endTime) {
        this();
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public StopWatch withTag(String tagFormat, Object ... tagArgs) {
        this.tagFormat = tagFormat;
        this.tagArgs = tagArgs;
        return this;
    }

    public StopWatch withCategory(String category) {
        this.category = category;
        this.logger = NALogger.getLogger("stopwatch." + category);
        return this;
    }

    public StopWatch start() {
        this.startTime = System.currentTimeMillis();
        this.endTime = -1L;
        return this;
    }

    public StopWatch stop() {
        if (this.startTime == -1L) {
            throw new IllegalStateException("Not started");
        }
        if (this.endTime != -1L) {
            throw new IllegalStateException("Already stopped");
        }
        this.endTime = System.currentTimeMillis();
        return this;
    }

    public void stopAndLog() {
        this.stop();
        this.log();
    }

    public void log() {
        if (this.isEnabled()) {
            String json = String.format("timing{\"tag\":\"%s\",\"start\":%d,\"end\":%d,\"elapsed\":%d,\"elapsedHMS\":\"%s\"}", this.getTag(), this.startTime, this.endTime, this.getElapsedTime(), this.getElapsedTimeHMS());
            this.logger.internalTrace(json);
        }
    }

    private String getTag() {
        return this.tagArgs.length == 0 ? this.tagFormat : String.format(this.tagFormat, this.tagArgs);
    }

    public long getElapsedTime() {
        if (this.startTime == -1L) {
            return 0L;
        }
        if (this.endTime == -1L) {
            return System.currentTimeMillis() - this.startTime;
        }
        return this.endTime - this.startTime;
    }

    public String getElapsedTimeHMS() {
        return DurationFormatUtils.formatDurationHMS((long)this.getElapsedTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> V trace(UncheckedCallable<V> callable) {
        this.start();
        try {
            V v = callable.call();
            return v;
        }
        finally {
            this.stopAndLog();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> V trace(Callable<V> callable) throws Exception {
        this.start();
        try {
            V v = callable.call();
            return v;
        }
        finally {
            this.stopAndLog();
        }
    }

    private void readObject(ObjectInputStream inputStream) throws IOException, ClassNotFoundException {
        inputStream.defaultReadObject();
        this.logger = this.category == null ? ROOT_LOGGER : NALogger.getLogger("stopwatch." + this.category);
    }

    public boolean isEnabled() {
        return this.logger.isLogLevelEnabled(LogLevel.TRACE);
    }
}

