/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.common.util;

import com.netapp.common.MsgKey;
import com.netapp.common.logging.MessageBundle;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;

public class AdapterFactory {
    private static final AdapterMethodInterceptor ADAPTER_METHOD_INTERCEPTOR = new AdapterMethodInterceptor();

    private AdapterFactory() {
    }

    public static <T extends Adapter> T buildAdapter(Class<T> clazz, Object adaptee) {
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(clazz);
        enhancer.setCallback((Callback)ADAPTER_METHOD_INTERCEPTOR);
        Adapter adapter = (Adapter)enhancer.create();
        adapter.setAdaptee(adaptee);
        return (T)adapter;
    }

    private static class AdapterMethodInterceptor
    implements MethodInterceptor,
    AdapteeInvoker {
        private AdapterMethodInterceptor() {
        }

        public Object intercept(Object object, Method adapterMethod, Object[] args, MethodProxy methodProxy) throws Throwable {
            if (!Modifier.isAbstract(adapterMethod.getModifiers())) {
                return methodProxy.invokeSuper(object, args);
            }
            if (adapterMethod.getName().equals("adapt")) {
                AdapteeInvoker adapteeInvoker = (AdapteeInvoker)args[0];
                Object adaptee = args[1];
                Method adapteeMethod = (Method)args[2];
                Object[] invocationArgs = (Object[])args[3];
                return adapteeInvoker.invoke(adaptee, adapteeMethod, invocationArgs);
            }
            if (adapterMethod.getName().equals("handleNullAdaptee")) {
                throw new IllegalStateException(MessageBundle.localizeMessage(MsgKey.UTIL_NULL_ADAPTEE, object.getClass().getName()));
            }
            Adapter adapter = (Adapter)object;
            if (adapter.getAdaptee() == null) {
                adapter.handleNullAdaptee();
            }
            Class<?> adapteeClass = adapter.getAdaptee().getClass();
            Method adapteeMethod = adapteeClass.getMethod(adapterMethod.getName(), adapterMethod.getParameterTypes());
            adapteeMethod.setAccessible(true);
            if (!adapterMethod.getReturnType().isAssignableFrom(adapteeMethod.getReturnType())) {
                throw new NoSuchMethodException(adapterMethod.toString());
            }
            return adapter.adapt(this, adapter.getAdaptee(), adapteeMethod, args);
        }

        @Override
        public Object invoke(Object adaptee, Method adapteeMethod, Object[] args) throws Throwable {
            try {
                return adapteeMethod.invoke(adaptee, args);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }
    }

    public static interface AdapteeInvoker {
        public Object invoke(Object var1, Method var2, Object[] var3) throws Throwable;
    }

    public static interface Adapter<T> {
        public T getAdaptee();

        public void setAdaptee(T var1);

        public void handleNullAdaptee();

        public Object adapt(AdapteeInvoker var1, Object var2, Method var3, Object[] var4) throws Throwable;
    }
}

