/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.common.util;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.netapp.common.util.ClassUtils;
import com.netapp.common.util.Transformer;
import com.netapp.common.util.TransformerFunctionAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.SystemUtils;

public class CollectionUtils {
    protected CollectionUtils() {
    }

    public static <T> T find(Iterable<T> iterable, Predicate<? super T> predicate) {
        Iterator iterator = Iterables.filter(iterable, predicate).iterator();
        return iterator.hasNext() ? (T)iterator.next() : null;
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isEmpty(Map<?, ?> m) {
        return m == null || m.isEmpty();
    }

    public static boolean isEmpty(Object[] a) {
        return a == null || a.length == 0;
    }

    public static <R, S extends R, T extends Collection<R>> T addAll(T collection, S ... ss) {
        for (S s : ss) {
            collection.add(s);
        }
        return collection;
    }

    @Deprecated
    public static <R, S, T extends Collection<S>> T transform(Collection<? extends R> oldCollection, T newCollection, Transformer<R, S> transformer) {
        for (R r : oldCollection) {
            newCollection.add(transformer.transform(r));
        }
        return newCollection;
    }

    public static <R, S, T extends Collection<S>> T transform(Iterable<? extends R> oldCollection, T newCollection, Function<R, S> function) {
        for (R r : oldCollection) {
            newCollection.add((Object)function.apply(r));
        }
        return newCollection;
    }

    public static <R, S> List<S> transformIntoList(Iterable<? extends R> oldCollection, Function<R, S> function) {
        return CollectionUtils.transform(oldCollection, new ArrayList(), function);
    }

    public static <R, S> Set<S> transformIntoSet(Iterable<? extends R> oldCollection, Function<R, S> function) {
        return CollectionUtils.transform(oldCollection, new HashSet(), function);
    }

    public static <R, S, T extends Collection<S>> T transformWithFilter(Iterable<? extends R> oldCollection, T newCollection, Function<R, S> function) {
        for (R r : oldCollection) {
            Object s = function.apply(r);
            if (s == null) continue;
            newCollection.add((Object)s);
        }
        return newCollection;
    }

    public static <R, S> List<S> transformWithFilterIntoList(Iterable<? extends R> oldCollection, Function<R, S> function) {
        return CollectionUtils.transformWithFilter(oldCollection, new ArrayList(), function);
    }

    public static <R, S> Set<S> transformWithFilterIntoSet(Iterable<? extends R> oldCollection, Function<R, S> function) {
        return CollectionUtils.transformWithFilter(oldCollection, new HashSet(), function);
    }

    public static <E, T extends Collection<E>> T filter(Iterable<? extends E> oldCollection, T newCollection, Predicate<E> predicate) {
        for (E e : oldCollection) {
            if (!predicate.apply(e)) continue;
            newCollection.add(e);
        }
        return newCollection;
    }

    public static <E> Set<E> filterIntoSet(Iterable<? extends E> oldCollection, Predicate<E> predicate) {
        return CollectionUtils.filter(oldCollection, new HashSet(), predicate);
    }

    public static <E> List<E> filterIntoList(Iterable<? extends E> oldCollection, Predicate<E> predicate) {
        return CollectionUtils.filter(oldCollection, new LinkedList(), predicate);
    }

    public static <T> List<? extends List<T>> partition(List<T> list, int bucketSize) {
        LinkedList buckets = new LinkedList();
        LinkedList<T> currentBucket = new LinkedList<T>();
        buckets.add(currentBucket);
        for (T t : list) {
            if (currentBucket.size() == bucketSize) {
                currentBucket = new LinkedList();
                buckets.add(currentBucket);
            }
            currentBucket.add(t);
        }
        return buckets;
    }

    public static String collectionToString(Collection<?> c, String delimiter) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<?> i = c.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            stringBuilder.append(o.toString());
            if (!i.hasNext()) continue;
            stringBuilder.append(delimiter);
        }
        return stringBuilder.toString();
    }

    public static String collectionToString(Collection<?> c, String delimiter, String prefix, String suffix) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<?> i = c.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            stringBuilder.append(prefix);
            stringBuilder.append(o.toString());
            stringBuilder.append(suffix);
            if (!i.hasNext()) continue;
            stringBuilder.append(delimiter);
        }
        return stringBuilder.toString();
    }

    public static String collectionToString(Collection<?> c) {
        return CollectionUtils.collectionToString(c, SystemUtils.LINE_SEPARATOR);
    }

    public static <E> Set<E> union(Collection<E> ... collections) {
        return CollectionUtils.unionInto(new HashSet(), collections);
    }

    public static <E, S extends Collection<E>> S unionInto(S union, Collection<E> ... collections) {
        for (Collection<E> collection : collections) {
            union.addAll(collection);
        }
        return union;
    }

    public static <E> Set<E> flatten(Collection<? extends Collection<E>> collections) {
        HashSet<E> set = new HashSet<E>();
        for (Collection<E> collection : collections) {
            set.addAll(collection);
        }
        return set;
    }

    public static <E> Set<E> dedupe(Collection<E> collections) {
        HashSet<E> set = new HashSet<E>();
        for (E e : collections) {
            set.add(e);
        }
        return set;
    }

    public static <E> Set<E> intersect(Set<E> s1, Set<E> s2) {
        HashSet<E> intersectSet = new HashSet<E>();
        for (E o : s1) {
            if (!s2.contains(o)) continue;
            intersectSet.add(o);
        }
        return intersectSet;
    }

    public static <E> boolean containsAny(Set<E> s1, Set<E> s2) {
        return !CollectionUtils.intersect(s1, s2).isEmpty();
    }

    public static <E> Set<E> difference(Set<E> s1, Set<E> s2) {
        HashSet<E> result = new HashSet<E>();
        for (E e : s1) {
            if (s2.contains(e)) continue;
            result.add(e);
        }
        return result;
    }

    public static <T> T[] append(T[] tArray, T ... tsToAppend) {
        ArrayList<T> retVal = new ArrayList<T>(tArray.length + tsToAppend.length);
        for (T t : tArray) {
            retVal.add(t);
        }
        for (T t : tsToAppend) {
            retVal.add(t);
        }
        return retVal.toArray(tArray);
    }

    public static <T> T[] prepend(T[] tArray, T ... tsToPrepend) {
        ArrayList<T> retVal = new ArrayList<T>(tArray.length + tsToPrepend.length);
        for (T t : tsToPrepend) {
            retVal.add(t);
        }
        for (T t : tArray) {
            retVal.add(t);
        }
        return retVal.toArray(tArray);
    }

    public static <S, T> Map<S, T> union(Map<S, T> ... maps) {
        HashMap<S, T> result = new HashMap<S, T>();
        for (Map<S, T> map : maps) {
            result.putAll(map);
        }
        return result;
    }

    public static <R, S, T> Map<R, T> merge(Map<R, S> map1, Map<S, T> map2) {
        HashMap<R, T> result = new HashMap<R, T>();
        for (Map.Entry<R, S> entry : map1.entrySet()) {
            result.put(entry.getKey(), map2.get(entry.getValue()));
        }
        return result;
    }

    @Deprecated
    public static <R, S, T, U> Map<R, U> merge(Map<R, S> map1, Map<T, U> map2, Transformer<S, T> transformer) {
        HashMap<R, U> result = new HashMap<R, U>();
        for (Map.Entry<R, S> entry : map1.entrySet()) {
            result.put(entry.getKey(), map2.get(transformer.transform(entry.getValue())));
        }
        return result;
    }

    public static <R, S, T, U> Map<R, U> merge(Map<R, S> map1, Map<T, U> map2, Function<S, T> function) {
        HashMap<R, U> result = new HashMap<R, U>();
        for (Map.Entry<R, S> entry : map1.entrySet()) {
            result.put(entry.getKey(), map2.get(function.apply(entry.getValue())));
        }
        return result;
    }

    public static <S, T> Set<T> getAll(Set<S> keys, Map<S, T> map) {
        HashSet<T> values = new HashSet<T>();
        for (S key : keys) {
            values.add(map.get(key));
        }
        return values;
    }

    @Deprecated
    public static <R, S, T, U> Map<T, U> transform(Map<R, S> map, Transformer<R, T> transformer1, Transformer<S, U> transformer2) {
        return CollectionUtils.transform(map, TransformerFunctionAdapter.create(transformer1), TransformerFunctionAdapter.create(transformer2));
    }

    public static <R, S, T, U> Map<T, U> transform(Map<R, S> map, Function<R, T> keyFunction, Function<S, U> valueFunction) {
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        for (Map.Entry<R, S> entry : map.entrySet()) {
            result.put(keyFunction.apply(entry.getKey()), valueFunction.apply(entry.getValue()));
        }
        return result;
    }

    @Deprecated
    public static <S, T> Map<S, T> map(Collection<S> collection, Transformer<? super S, T> transformer) {
        HashMap<S, T> result = new HashMap<S, T>();
        for (S s : collection) {
            result.put(s, transformer.transform(s));
        }
        return result;
    }

    public static <S, T> Map<T, S> index(Collection<S> collection, Function<? super S, T> function) {
        HashMap<Object, S> result = new HashMap<Object, S>();
        for (S s : collection) {
            result.put(function.apply(s), s);
        }
        return result;
    }

    public static <S, T> Map<T, S> index(Collection<S> collection, String beanPropertyName) {
        Function functionForBeanProperty = ClassUtils.createFunctionForBeanProperty(beanPropertyName);
        return CollectionUtils.index(collection, functionForBeanProperty);
    }

    @Deprecated
    public static <S, T> Map<T, S> index(Collection<S> collection, Transformer<? super S, T> transformer) {
        return CollectionUtils.index(collection, TransformerFunctionAdapter.create(transformer));
    }

    public static <S, T> Map<T, Set<S>> reverse(Map<S, T> map) {
        HashMap<T, HashSet<S>> result = new HashMap<T, HashSet<S>>();
        for (Map.Entry<S, T> entry : map.entrySet()) {
            HashSet<S> ss = (HashSet<S>)result.get(entry.getValue());
            if (ss == null) {
                ss = new HashSet<S>();
                result.put(entry.getValue(), ss);
            }
            ss.add(entry.getKey());
        }
        return result;
    }

    public static <T> T getSingleMember(Collection<T> collection) {
        assert (collection.size() == 1);
        return collection.iterator().next();
    }

    public static <T> T getIgnoreCase(Map<String, T> map, String key) {
        for (Map.Entry<String, T> entry : map.entrySet()) {
            if (!entry.getKey().equalsIgnoreCase(key)) continue;
            return entry.getValue();
        }
        return null;
    }

    public static <T> Set<T> nullSafe(Set<T> set) {
        return set == null ? Collections.emptySet() : set;
    }

    public static <T> List<T> nullSafe(List<T> list) {
        return list == null ? Collections.emptyList() : list;
    }

    public static <S, T> Map<S, T> nullSafe(Map<S, T> map) {
        return map == null ? Collections.emptyMap() : map;
    }

    public static <T> List<T> merge(List<? extends T> list1, List<? extends T> list2, Comparator<? super T> comparator) {
        Object nextJ;
        LinkedList<Object> mergedList = new LinkedList<Object>();
        Iterator<T> i = list1.iterator();
        Iterator<T> j = list2.iterator();
        Object nextI = i.hasNext() ? i.next() : null;
        Object v0 = nextJ = j.hasNext() ? j.next() : null;
        while (nextI != null || nextJ != null) {
            int comparison = nextI == null ? 1 : (nextJ == null ? -1 : comparator.compare(nextI, nextJ));
            if (comparison < 0) {
                mergedList.add(nextI);
                nextI = i.hasNext() ? i.next() : null;
                continue;
            }
            if (comparison > 0) {
                mergedList.add(nextJ);
                nextJ = j.hasNext() ? j.next() : null;
                continue;
            }
            mergedList.add(nextI);
            nextI = i.hasNext() ? i.next() : null;
        }
        return mergedList;
    }

    public static <T> boolean isSorted(Collection<T> collection, Comparator<? super T> comparator) {
        Object previous = null;
        for (T current : collection) {
            if (previous != null && comparator.compare(previous, current) > 0) {
                return false;
            }
            previous = current;
        }
        return true;
    }
}

