/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.common.util;

import com.netapp.common.MsgKey;
import com.netapp.common.logging.MessageKey;
import com.netapp.common.logging.NALogger;
import com.netapp.common.util.ConfigProperty;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;

public class ConfigBundle
extends Properties {
    private static final long serialVersionUID = 1L;
    private static final NALogger logger = NALogger.getLogger(ConfigBundle.class);
    private static final ConfigProperty<File> INSTALL_DIR_PROPERTY = new ConfigProperty<File>(File.class, "install.dir");
    private File installDir;
    private boolean useSystemProperties;
    private String systemPropertiesPrefix = "";

    public ConfigBundle() {
    }

    public ConfigBundle(String ... configFiles) {
        this(Thread.currentThread().getContextClassLoader(), configFiles);
    }

    public ConfigBundle(ClassLoader classLoader, String ... configFiles) {
        this(classLoader, Arrays.asList(configFiles));
    }

    public ConfigBundle(Collection<String> configFiles) {
        this(Thread.currentThread().getContextClassLoader(), configFiles);
    }

    public ConfigBundle(ClassLoader classLoader, Collection<String> configFiles) {
        this();
        String file = null;
        try {
            for (String ifile : configFiles) {
                file = ifile;
                InputStream stream = classLoader.getResourceAsStream(file);
                if (stream == null) continue;
                this.load(stream);
                stream.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(logger.error((MessageKey)MsgKey.UTIL_CONFIG_EXCEPTION_LOADING_FILE, e, file, e.getLocalizedMessage()));
        }
    }

    public ConfigBundle(Properties properties) {
        this();
        this.putAll((Map<?, ?>)properties);
    }

    public ConfigBundle(ConfigBundle ... bundles) {
        this();
        for (ConfigBundle bundle : bundles) {
            if (bundle == null) continue;
            this.putAll((Map<?, ?>)bundle);
        }
    }

    public void setUseSystemProperties(boolean useSystemProperties) {
        this.useSystemProperties = useSystemProperties;
    }

    public void setSystemPropertiesPrefix(String systemPropertiesPrefix) {
        this.systemPropertiesPrefix = systemPropertiesPrefix;
    }

    @Override
    public String getProperty(String key) {
        String property;
        if (this.useSystemProperties && (property = System.getProperty(this.systemPropertiesPrefix + key)) != null) {
            return property;
        }
        return super.getProperty(key);
    }

    public File getInstallDir() {
        String env;
        if (this.installDir == null) {
            this.installDir = INSTALL_DIR_PROPERTY.lookup(this);
        }
        if (this.installDir == null && (env = System.getenv("INSTALL_DIR")) != null) {
            this.installDir = new File(env);
        }
        if (this.installDir == null) {
            this.installDir = new File(".");
        }
        return this.installDir;
    }

    @Deprecated
    public Properties getProperties() {
        return this;
    }

    @Deprecated
    public static Properties load(ClassLoader loader, String[] configFiles) {
        String file = null;
        Properties returnProps = new Properties();
        try {
            for (String ifile : configFiles) {
                file = ifile;
                InputStream stream = loader.getResourceAsStream(file);
                if (stream == null) continue;
                Properties props = new Properties(returnProps);
                props.load(stream);
                stream.close();
                returnProps = props;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(logger.error((MessageKey)MsgKey.UTIL_CONFIG_EXCEPTION_LOADING_FILE, e, file, e.getLocalizedMessage()));
        }
        return returnProps;
    }

    @Override
    public synchronized int hashCode() {
        return super.hashCode();
    }

    @Override
    public synchronized boolean equals(Object o) {
        return super.equals(o);
    }
}

