/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.common.util;

import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Interval
implements Comparable<Interval> {
    private static final Pattern TIME_STRING_PATTERN = Pattern.compile("(-)?\\s*(?:(\\d+):)?(\\d+):(\\d+):(\\d+)");
    private static final int TIME_STRING_SIGN_GROUP = 1;
    private static final int TIME_STRING_DAY_GROUP = 2;
    private static final int TIME_STRING_HOUR_GROUP = 3;
    private static final int TIME_STRING_MIN_GROUP = 4;
    private static final int TIME_STRING_SEC_GROUP = 5;
    private static final Pattern TIME_SUFFIX_PATTERN = Pattern.compile("(-?\\d+(?:\\.\\d*)?)\\s*(\\w+)");
    private static final int TIME_SUFFIX_VALUE_GROUP = 1;
    private static final int TIME_SUFFIX_UNIT_GROUP = 2;
    public static final String[] SECOND_UNITS = new String[]{"s", "sec", "secs", "seond", "seconds"};
    public static final double SECOND_MUTLIPLIER = 1.0;
    public static final String[] MINUTE_UNITS = new String[]{"m", "min", "mins", "minute", "minutes"};
    public static final double MINUTE_MULTIPLIER = 60.0;
    public static final String[] HOUR_UNITS = new String[]{"h", "hr", "hrs", "hour", "hours"};
    public static final double HOUR_MULTIPLIER = 3600.0;
    public static final String[] DAY_UNITS = new String[]{"d", "day", "days"};
    public static final double DAY_MULTIPLIER = 86400.0;
    public static final String[] WEEK_UNITS = new String[]{"w", "wk", "week", "weeks"};
    public static final double WEEK_MULTIPLIER = 604800.0;
    private static final Map<String, Double> TIME_MULTIPLIERS = new ImmutableMap.Builder().put((Object)"s", (Object)1.0).put((Object)"sec", (Object)1.0).put((Object)"second", (Object)1.0).put((Object)"seconds", (Object)1.0).put((Object)"m", (Object)60.0).put((Object)"min", (Object)60.0).put((Object)"mins", (Object)60.0).put((Object)"minute", (Object)60.0).put((Object)"minutes", (Object)60.0).put((Object)"h", (Object)3600.0).put((Object)"hr", (Object)3600.0).put((Object)"hrs", (Object)3600.0).put((Object)"hour", (Object)3600.0).put((Object)"hours", (Object)3600.0).put((Object)"d", (Object)86400.0).put((Object)"day", (Object)86400.0).put((Object)"days", (Object)86400.0).put((Object)"w", (Object)604800.0).put((Object)"wk", (Object)604800.0).put((Object)"wks", (Object)604800.0).put((Object)"week", (Object)604800.0).put((Object)"weeks", (Object)604800.0).build();
    private final long seconds;

    public Interval(long seconds) {
        this.seconds = seconds;
    }

    public Interval(String value) {
        this.seconds = Interval.parse(value);
    }

    public long getSeconds() {
        return this.seconds;
    }

    public long getMillis() {
        return this.seconds * 1000L;
    }

    @SuppressWarnings(value={"FE"})
    public String getSuffixString() {
        double dval;
        String units;
        if (Math.abs(this.seconds) < 60L) {
            units = "second";
            dval = this.seconds;
        } else if (Math.abs(this.seconds) < 3600L) {
            units = "minute";
            dval = (double)this.seconds / 60.0;
        } else if (Math.abs(this.seconds) < 86400L) {
            units = "hour";
            dval = (double)this.seconds / 3600.0;
        } else if (Math.abs(this.seconds) < 604800L) {
            units = "day";
            dval = (double)this.seconds / 86400.0;
        } else {
            units = "week";
            dval = (double)this.seconds / 604800.0;
        }
        String str = 1.0 == dval ? String.format("1 %s", units) : (0.0 == dval - (double)((int)dval) ? String.format("%.0f %ss", dval, units) : (0.0 == dval * 10.0 - (double)((int)(dval * 10.0)) ? String.format("%.1f %ss", dval, units) : String.format("%.2f %ss", dval, units)));
        return str;
    }

    public String getTimeString() {
        String str = this.seconds <= -86400L ? String.format("-%d:%02d:%02d:%02d", -this.seconds / 86400L, -this.seconds / 3600L % 24L, -this.seconds / 60L % 60L, -this.seconds % 60L) : (this.seconds < 0L ? String.format("-%02d:%02d:%02d", -this.seconds / 3600L, -this.seconds / 60L % 60L, -this.seconds % 60L) : (this.seconds < 86400L ? String.format("%02d:%02d:%02d", this.seconds / 3600L, this.seconds / 60L % 60L, this.seconds % 60L) : String.format("%d:%02d:%02d:%02d", this.seconds / 86400L, this.seconds / 3600L % 24L, this.seconds / 60L % 60L, this.seconds % 60L)));
        return str;
    }

    public String toString() {
        return this.getTimeString();
    }

    public static long parse(String value) {
        Matcher matcher = TIME_STRING_PATTERN.matcher(value);
        if (matcher.matches()) {
            int sign = 1;
            int d = 0;
            int h = 0;
            int m = 0;
            int s = 0;
            if (matcher.group(1) != null) {
                sign = -1;
            }
            if (matcher.group(2) != null) {
                d = Integer.parseInt(matcher.group(2), 10);
            }
            h = Integer.parseInt(matcher.group(3));
            m = Integer.parseInt(matcher.group(4));
            s = Integer.parseInt(matcher.group(5));
            return (long)sign * ((long)s + 60L * ((long)m + 60L * ((long)h + 24L * (long)d)));
        }
        matcher = TIME_SUFFIX_PATTERN.matcher(value);
        if (matcher.matches()) {
            double dval = Double.parseDouble(matcher.group(1));
            int ival = 0;
            String suffix = matcher.group(2).toLowerCase();
            Double mult = TIME_MULTIPLIERS.get(suffix);
            if (mult != null) {
                ival = (dval *= mult.doubleValue()) < 0.0 ? (int)(dval - 0.5) : (int)(dval + 0.5);
                return ival;
            }
            throw new IllegalArgumentException(value);
        }
        throw new IllegalArgumentException(value);
    }

    public int hashCode() {
        return (int)(this.seconds ^ this.seconds >>> 32);
    }

    public boolean equals(Object o) {
        return o instanceof Interval && ((Interval)o).seconds == this.seconds;
    }

    @Override
    public int compareTo(Interval o) {
        long thisVal = this.seconds;
        long anotherVal = o.seconds;
        return thisVal < anotherVal ? -1 : (thisVal == anotherVal ? 0 : 1);
    }
}

