/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.common.util;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class Version
implements Comparable<Version> {
    private String versionString;

    public Version(String versionString) {
        this.versionString = versionString;
    }

    @Override
    public int compareTo(Version other) {
        return this.compareTo(other, 0);
    }

    public int compareTo(Version other, int significance) {
        if (this.versionString.equalsIgnoreCase(other.versionString)) {
            return 0;
        }
        List<String> myVersionParts = this.split();
        List<String> otherVersionParts = other.split();
        int longerLength = Math.max(myVersionParts.size(), otherVersionParts.size());
        if (myVersionParts.size() != otherVersionParts.size()) {
            List<String> shorterList = myVersionParts.size() < otherVersionParts.size() ? myVersionParts : otherVersionParts;
            do {
                shorterList.add("0");
            } while (shorterList.size() < longerLength);
        }
        if (significance > 0 && significance < longerLength) {
            longerLength = significance;
        }
        for (int i = 0; i < longerLength; ++i) {
            int compare = myVersionParts.get(i).compareTo(otherVersionParts.get(i));
            if (compare == 0) continue;
            return compare;
        }
        return 0;
    }

    private List<String> split() {
        ArrayList<String> myVersionParts = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(this.versionString, ".");
        while (st.hasMoreTokens()) {
            myVersionParts.add(st.nextToken());
        }
        return myVersionParts;
    }

    public boolean isEquivalentTo(Version other) {
        return this.compareTo(other) == 0;
    }

    public boolean isGreaterThan(Version other) {
        return this.compareTo(other) > 0;
    }

    public boolean isGreaterThanOrEqualTo(Version other) {
        return this.compareTo(other) >= 0;
    }

    public boolean isLessThan(Version other) {
        return this.compareTo(other) < 0;
    }

    public boolean isLessThanOrEqualTo(Version other) {
        return this.compareTo(other) <= 0;
    }

    public String toString() {
        return this.versionString;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Version)) {
            return false;
        }
        Version other = (Version)obj;
        return this.versionString.equals(other.versionString);
    }

    public int hashCode() {
        return this.versionString.hashCode();
    }
}

