/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.common.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.CopyOnWriteArrayList;

public class WeakBag<E>
implements Iterable<E> {
    private List<Reference<E>> bag = new CopyOnWriteArrayList<Reference<E>>();
    private ReferenceQueue<E> expired = new ReferenceQueue();

    public void add(E o) {
        for (Reference<E> t : this.bag) {
            if (t.get() != o) continue;
            return;
        }
        this.bag.add(new WeakReference<E>(o, this.expired));
    }

    @Override
    public Iterator<E> iterator() {
        Reference<E> ref = this.expired.poll();
        while (ref != null) {
            this.bag.remove(ref);
            ref = this.expired.poll();
        }
        return new WeakBagIterator<E>(this.bag.iterator());
    }

    private static class WeakBagIterator<E>
    implements Iterator<E> {
        private Iterator<Reference<E>> iter;
        private E next;

        public WeakBagIterator(Iterator<Reference<E>> iter) {
            this.iter = iter;
            this.next = this.fixNext();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public E next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            E current = this.next;
            this.next = this.fixNext();
            return current;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private E fixNext() {
            while (this.iter.hasNext()) {
                E obj = this.iter.next().get();
                if (obj == null) continue;
                return obj;
            }
            return null;
        }
    }
}

