/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.crypto;

import com.netapp.crypto.SymmetricCipherDelegate;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import java.util.concurrent.Callable;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

class Aes128CbcPkcs5PaddingCipherDelegate
extends SymmetricCipherDelegate {
    private static final int ID = 0;
    private static final String TRANSFORMATION = "AES/CBC/PKCS5Padding";
    private static final int IV_BIT_LENGTH = 128;
    private static final String KEY_GENERATION_ALGORITHM = "AES";
    private static final int KEY_BIT_LENGTH = 128;

    public Aes128CbcPkcs5PaddingCipherDelegate(Callable<SecureRandom> secureRandomFactory) {
        super(0, TRANSFORMATION, 128, KEY_GENERATION_ALGORITHM, 128, secureRandomFactory);
    }

    @Override
    public byte[] encrypt(SecretKey key, byte[] plainText) throws InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, IOException {
        byte[] iv = new byte[this.getCipherIvBitLength() / 8];
        this.getSecureRandom().nextBytes(iv);
        Cipher cipher = this.getCipher();
        cipher.init(1, (Key)key, new IvParameterSpec(iv));
        byte[] cipherTextBytes = cipher.doFinal(plainText);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(iv.length + cipherTextBytes.length);
        baos.write(iv);
        baos.write(cipherTextBytes);
        baos.close();
        return baos.toByteArray();
    }

    @Override
    public byte[] decrypt(SecretKey key, byte[] cipherText) throws IllegalBlockSizeException, BadPaddingException, IOException, InvalidKeyException, InvalidAlgorithmParameterException {
        int ivByteLength = this.getCipherIvBitLength() / 8;
        Cipher cipher = this.getCipher();
        cipher.init(2, (Key)key, new IvParameterSpec(cipherText, 0, ivByteLength));
        byte[] plainText = cipher.doFinal(cipherText, ivByteLength, cipherText.length - ivByteLength);
        return plainText;
    }
}

