/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.collectors.vmware;

import com.netapp.collectors.vmware.IVMWareContext;
import com.netapp.collectors.vmware.IVMWareService;
import com.netapp.collectors.vmware.VMWareServiceFactory;
import com.netapp.collectors.vmware.exceptions.VMWareConfigurationException;
import com.netapp.collectors.vmware.util.PropertyFileUtil;
import com.netapp.collectors.vmware.util.SpecBuilderUtil;
import com.netapp.collectors.vmware.util.VMWareDataFetcher;
import com.vmware.vim25.ArrayOfVirtualDevice;
import com.vmware.vim25.DynamicProperty;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.ObjectContent;
import com.vmware.vim25.PerfCounterInfo;
import com.vmware.vim25.PerfEntityMetricBase;
import com.vmware.vim25.PerfEntityMetricCSV;
import com.vmware.vim25.PerfMetricSeriesCSV;
import com.vmware.vim25.RetrieveResult;
import com.vmware.vim25.ServiceContent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.datatype.DatatypeConfigurationException;

public class MainClass {
    public static Map<String, Integer> metricsCounterIdMap = new HashMap<String, Integer>();
    public static Map<Integer, PerfCounterInfo> counterInfoMap = new HashMap<Integer, PerfCounterInfo>();

    public static void main(String[] args) throws RuntimeException {
        System.out.println("Creating a VMware instance");
        String virtualCenterUrl = "https://nbs-vc65u1-11-10.lab.eng.btc.netapp.in/sdk";
        IVMWareService vmwareService = VMWareServiceFactory.getVMWareService((String)virtualCenterUrl);
        System.out.println("Vcenter being connected to is: " + virtualCenterUrl);
        IVMWareContext vmWareContext = vmwareService.connectAndGetContext("Administrator@vsphere.local", "Netapp123!", virtualCenterUrl, "nbs-vc65u1-11-10.lab.eng.btc.netapp.i", true, "VIRTUAL_CENTER", 1L, 300);
        System.out.println("VMware context from vmware service is retrieved");
        Integer maxRecords = 100;
        String nextToken = null;
        int counter = 0;
        HashMap<String, ManagedObjectReference> virtualMachineMap = new HashMap<String, ManagedObjectReference>();
        HashMap<String, List> virtualDiskMap = new HashMap<String, List>();
        HashMap<String, List<String>> moidInstancemap = new HashMap<String, List<String>>();
        do {
            RetrieveResult retrieveResult = VMWareDataFetcher.retrieveManagedObjectsAndProperties((ManagedObjectReference)((ServiceContent)vmWareContext.getServiceContent()).getRootFolder(), (List)SpecBuilderUtil.buildPropertySetForVm(), (List)SpecBuilderUtil.buildFullTraversal(), (boolean)false, (IVMWareContext)vmWareContext, (Integer)maxRecords, nextToken);
            List objects = retrieveResult.getObjects();
            System.out.println(String.format("Total Objects received in iteration %s: %s", ++counter, objects.size()));
            nextToken = retrieveResult.getToken();
            for (ObjectContent oc : objects) {
                List dps = oc.getPropSet();
                String moid = oc.getObj().getValue();
                virtualMachineMap.put(moid, oc.getObj());
                moidInstancemap.put(moid, Arrays.asList("*"));
                System.out.println("\"" + moid + "\",");
                for (DynamicProperty dp : dps) {
                    if (!dp.getName().equals("config.hardware.device")) continue;
                    System.out.println("disk details - " + dp.getVal());
                    List virtualDevices = ((ArrayOfVirtualDevice)dp.getVal()).getVirtualDevice();
                    virtualDiskMap.put(moid, virtualDevices);
                }
            }
        } while (nextToken != null);
        ArrayList morList = new ArrayList(virtualMachineMap.values());
        int batchCounter = 63;
        Map availablePerfMetricsMaps = VMWareDataFetcher.retrieveAvailablePerfMetricsMaps((IVMWareContext)vmWareContext);
        counterInfoMap = (HashMap)availablePerfMetricsMaps.get("counterInfoMap");
        metricsCounterIdMap = (Map)availablePerfMetricsMaps.get("metricsCounterMap");
        List propertyList = PropertyFileUtil.returnPerfCountersForHostDatastore();
        List counters = SpecBuilderUtil.buildCountersFromProperties((List)propertyList, metricsCounterIdMap);
        MainClass.getStatsForMor(moidInstancemap, "VirtualMachine", vmWareContext, counters);
    }

    private static void getStatsForMor(Map<String, List<String>> moidInstancemap, String type, IVMWareContext vmWareContext, List<Integer> counters) {
        List perfEntityMetricBases = null;
        try {
            perfEntityMetricBases = VMWareDataFetcher.retrievePerfData((String)type, moidInstancemap, (IVMWareContext)vmWareContext, counters, (int)-1);
            MainClass.printStats(perfEntityMetricBases);
        }
        catch (VMWareConfigurationException | DatatypeConfigurationException e) {
            System.out.println("Error while formatting the time");
        }
    }

    private static void printStats(List<PerfEntityMetricBase> perfEntityMetricBases) {
        for (PerfEntityMetricBase singleEntityPerfStats : perfEntityMetricBases) {
            PerfEntityMetricCSV entityStatsCsv = (PerfEntityMetricCSV)singleEntityPerfStats;
            List metricsValues = entityStatsCsv.getValue();
            if (metricsValues.isEmpty()) {
                System.out.println("No stats retrieved. Check whether the virtual machine is powered on.");
                throw new RuntimeException("No stats recieved");
            }
            String csvTimeInfoAboutStats = entityStatsCsv.getSampleInfoCSV();
            System.out.println("Collection: interval (seconds),time (yyyy-mm-ddThh:mm:ssZ)");
            System.out.println(csvTimeInfoAboutStats);
            System.out.println("For host - " + singleEntityPerfStats.getEntity().getValue());
            for (PerfMetricSeriesCSV csv : metricsValues) {
                PerfCounterInfo pci = counterInfoMap.get(csv.getId().getCounterId());
                System.out.println("----------------------------------------");
                System.out.println(pci.getGroupInfo().getKey() + "." + pci.getNameInfo().getKey() + "." + pci.getRollupType());
                System.out.println("Instance: " + csv.getId().getInstance());
                System.out.println("Values: " + csv.getValue());
            }
        }
    }
}

