/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.corba.types;

import javax.xml.namespace.QName;
import org.apache.cxf.binding.corba.CorbaTypeMap;
import org.apache.cxf.binding.corba.types.AbstractCorbaTypeListener;
import org.apache.cxf.binding.corba.types.CorbaArrayHandler;
import org.apache.cxf.binding.corba.types.CorbaHandlerUtils;
import org.apache.cxf.binding.corba.types.CorbaObjectHandler;
import org.apache.cxf.binding.corba.types.CorbaTypeListener;
import org.apache.cxf.binding.corba.wsdl.Anonarray;
import org.apache.cxf.binding.corba.wsdl.Array;
import org.apache.cxf.binding.corba.wsdl.CorbaTypeImpl;
import org.apache.cxf.service.model.ServiceInfo;
import org.omg.CORBA.ORB;

public class CorbaArrayListener
extends AbstractCorbaTypeListener {
    private final CorbaArrayHandler value;
    private final QName arrayElementType;
    private final ORB orb;
    private final CorbaTypeMap typeMap;
    private QName currentElName;
    private CorbaTypeListener currentTypeListener;
    private ServiceInfo serviceInfo;

    public CorbaArrayListener(CorbaObjectHandler handler, CorbaTypeMap map, ORB orbRef, ServiceInfo sInfo) {
        super(handler);
        this.value = (CorbaArrayHandler)handler;
        this.orb = orbRef;
        this.typeMap = map;
        this.serviceInfo = sInfo;
        CorbaTypeImpl arrayType = handler.getType();
        if (arrayType instanceof Anonarray) {
            Anonarray anonType = (Anonarray)arrayType;
            this.arrayElementType = anonType.getElemtype();
        } else {
            Array type = (Array)arrayType;
            this.arrayElementType = type.getElemtype();
        }
    }

    @Override
    public void processStartElement(QName name) {
        if (this.currentTypeListener == null) {
            this.currentElName = name;
            this.currentTypeListener = CorbaHandlerUtils.getTypeListener(name, this.arrayElementType, this.typeMap, this.orb, this.serviceInfo);
            this.currentTypeListener.setNamespaceContext(this.ctx);
            this.value.addElement(this.currentTypeListener.getCorbaObject());
        } else {
            this.currentTypeListener.processStartElement(name);
        }
    }

    @Override
    public void processEndElement(QName name) {
        if (this.currentTypeListener != null) {
            this.currentTypeListener.processEndElement(name);
            if (this.currentElName.equals(name)) {
                this.currentTypeListener = null;
            }
        }
    }

    @Override
    public void processCharacters(String text) {
        this.currentTypeListener.processCharacters(text);
    }

    @Override
    public void processWriteAttribute(String prefix, String namespaceURI, String localName, String val) {
        if (this.currentTypeListener != null) {
            this.currentTypeListener.processWriteAttribute(prefix, namespaceURI, localName, val);
        }
    }

    @Override
    public void processWriteNamespace(String prefix, String namespaceURI) {
        if (this.currentTypeListener != null) {
            this.currentTypeListener.processWriteNamespace(prefix, namespaceURI);
        }
    }
}

