/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.java2wsdl.processor.internal.jaxws.generator;

import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.model.JavaInterface;
import org.apache.cxf.tools.common.model.JavaModel;
import org.apache.cxf.tools.java2wsdl.processor.internal.jaxws.generator.AbstractJaxwsGenerator;

public class JaxwsImplGenerator
extends AbstractJaxwsGenerator {
    private static final String IMPL_TEMPLATE = "org/apache/cxf/tools/java2wsdl/processor/internal/jaxws/generator/template/javafirst-impl.vm";

    public JaxwsImplGenerator() {
        this.name = "impl.generator";
    }

    @Override
    public boolean passthrough() {
        Boolean genFromSei = (Boolean)this.env.get("genFromSEI");
        return genFromSei == false || !this.env.optionSet("server") || this.env.optionSet("implClass");
    }

    @Override
    public void generate(ToolContext penv) throws ToolException {
        this.env = penv;
        JavaModel javaModel = this.env.get(JavaModel.class);
        if (this.passthrough()) {
            return;
        }
        Map<String, JavaInterface> interfaces = javaModel.getInterfaces();
        QName service = (QName)this.env.get("serviceName");
        for (JavaInterface intf : interfaces.values()) {
            this.clearAttributes();
            this.setAttributes("intf", intf);
            this.setAttributes("service", service);
            this.setCommonAttributes();
            this.doWrite(IMPL_TEMPLATE, this.parseOutputName(intf.getPackageName(), intf.getName() + "Impl"));
            this.env.put("implClass", intf.getFullClassName() + "Impl");
        }
    }
}

