/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms.uri;

import java.net.URI;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.transport.jms.uri.DeliveryModeType;
import org.apache.cxf.transport.jms.uri.JMSEndpoint;
import org.apache.cxf.transport.jms.uri.JMSJNDIEndpoint;
import org.apache.cxf.transport.jms.uri.JMSQueueEndpoint;
import org.apache.cxf.transport.jms.uri.JMSTopicEndpoint;
import org.apache.cxf.transport.jms.uri.JMSURIConstants;
import org.apache.cxf.transport.jms.uri.MessageType;
import org.apache.cxf.transport.jms.uri.ResolveEndpointFailedException;
import org.apache.cxf.transport.jms.uri.URISupport;
import org.apache.cxf.transport.jms.uri.UnsafeUriCharactersEncoder;

public final class JMSEndpointParser {
    private static final Logger LOG = LogUtils.getL7dLogger(JMSEndpointParser.class);

    private JMSEndpointParser() {
    }

    public static JMSEndpoint createEndpoint(String uri) throws Exception {
        int idx;
        URI u = new URI(UnsafeUriCharactersEncoder.encode(uri));
        String path = u.getSchemeSpecificPart();
        if (path.startsWith("//")) {
            path = path.substring(2);
        }
        if ((idx = path.indexOf(63)) > 0) {
            path = path.substring(0, idx);
        }
        Map<String, String> parameters = URISupport.parseParameters(u);
        JMSEndpointParser.validateURI(uri, path, parameters);
        LOG.log(Level.FINE, "Creating endpoint uri=[" + uri + "], path=[" + path + "], parameters=[" + parameters + "]");
        JMSEndpoint endpoint = JMSEndpointParser.createEndpoint(uri, path);
        if (endpoint == null) {
            return null;
        }
        if (parameters != null) {
            JMSEndpointParser.configureProperties(endpoint, parameters);
        }
        return endpoint;
    }

    private static void configureProperties(JMSEndpoint endpoint, Map<String, String> parameters) {
        String deliveryMode = JMSEndpointParser.getAndRemoveParameter(parameters, "deliveryMode");
        String timeToLive = JMSEndpointParser.getAndRemoveParameter(parameters, "timeToLive");
        String priority = JMSEndpointParser.getAndRemoveParameter(parameters, "priority");
        String replyToName = JMSEndpointParser.getAndRemoveParameter(parameters, "replyToName");
        String topicReplyToName = JMSEndpointParser.getAndRemoveParameter(parameters, "topicReplyToName");
        String jndiConnectionFactoryName = JMSEndpointParser.getAndRemoveParameter(parameters, "jndiConnectionFactoryName");
        String jndiInitialContextFactory = JMSEndpointParser.getAndRemoveParameter(parameters, "jndiInitialContextFactory");
        String jndiUrl = JMSEndpointParser.getAndRemoveParameter(parameters, "jndiURL");
        String messageType = JMSEndpointParser.getAndRemoveParameter(parameters, "messageType");
        if (deliveryMode != null) {
            endpoint.setDeliveryMode(DeliveryModeType.valueOf(deliveryMode));
        }
        if (timeToLive != null) {
            endpoint.setTimeToLive(Long.valueOf(timeToLive));
        }
        if (priority != null) {
            endpoint.setPriority(Integer.valueOf(priority));
        }
        if (replyToName != null && topicReplyToName != null) {
            throw new IllegalArgumentException("The replyToName and topicReplyToName should not be defined at the same time.");
        }
        if (replyToName != null) {
            endpoint.setReplyToName(replyToName);
        }
        if (topicReplyToName != null) {
            endpoint.setTopicReplyToName(topicReplyToName);
        }
        if (jndiConnectionFactoryName != null) {
            endpoint.setJndiConnectionFactoryName(jndiConnectionFactoryName);
        }
        if (jndiInitialContextFactory != null) {
            endpoint.setJndiInitialContextFactory(jndiInitialContextFactory);
        }
        if (jndiUrl != null) {
            endpoint.setJndiURL(jndiUrl);
        }
        if (messageType != null) {
            endpoint.setMessageType(MessageType.fromValue(messageType));
        }
        for (String key : parameters.keySet()) {
            String value = parameters.get(key);
            if (value == null || value.equals("")) continue;
            if (key.startsWith("jndi-")) {
                key = key.substring(5);
                endpoint.putJndiParameter(key, value);
                continue;
            }
            endpoint.putParameter(key, value);
        }
    }

    private static String getAndRemoveParameter(Map<String, String> parameters, String parameterName) {
        String value = parameters.get(parameterName);
        parameters.remove(parameterName);
        return value;
    }

    protected static void validateURI(String uri, String path, Map<String, String> parameters) throws ResolveEndpointFailedException {
        if (uri.contains("&") && !uri.contains("?")) {
            throw new ResolveEndpointFailedException(uri, "Invalid uri syntax: no ? marker however the uri has & parameter separators. Check the uri if its missing a ? marker.");
        }
        if (uri.contains("&&")) {
            throw new ResolveEndpointFailedException(uri, "Invalid uri syntax: Double && marker found. Check the uri and remove the duplicate & marker.");
        }
    }

    protected static JMSEndpoint createEndpoint(String uri, String remaining) throws Exception {
        boolean isQueue = false;
        boolean isTopic = false;
        boolean isJndi = false;
        if (remaining.startsWith("queue:")) {
            remaining = JMSEndpointParser.removeStartingCharacters(remaining.substring("queue:".length()), '/');
            isQueue = true;
        } else if (remaining.startsWith("topic:")) {
            remaining = JMSEndpointParser.removeStartingCharacters(remaining.substring("topic:".length()), '/');
            isTopic = true;
        } else if (remaining.startsWith("jndi:")) {
            remaining = JMSEndpointParser.removeStartingCharacters(remaining.substring("jndi:".length()), '/');
            isJndi = true;
        } else {
            throw new Exception("Unknow JMS Variant");
        }
        String subject = JMSEndpointParser.convertPathToActualDestination(remaining);
        JMSEndpoint endpoint = null;
        if (isQueue) {
            endpoint = new JMSQueueEndpoint(uri, subject);
        } else if (isTopic) {
            endpoint = new JMSTopicEndpoint(uri, subject);
        } else if (isJndi) {
            endpoint = new JMSJNDIEndpoint(uri, subject);
        }
        return endpoint;
    }

    protected static String convertPathToActualDestination(String path) {
        return path;
    }

    public static JMSURIConstants getConfiguration() {
        return null;
    }

    public static String removeStartingCharacters(String text, char ch) {
        int idx = 0;
        while (text.charAt(idx) == ch) {
            ++idx;
        }
        if (idx > 0) {
            return text.substring(idx);
        }
        return text;
    }
}

