/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.maven;

import java.io.File;
import java.io.FileInputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProjectHelper;
import org.vafer.jdeb.Console;
import org.vafer.jdeb.DataConsumer;
import org.vafer.jdeb.DataProducer;
import org.vafer.jdeb.PackagingException;
import org.vafer.jdeb.descriptors.AbstractDescriptor;
import org.vafer.jdeb.maven.AbstractPluginMojo;
import org.vafer.jdeb.maven.Data;
import org.vafer.jdeb.maven.DebMaker;
import org.vafer.jdeb.utils.MapVariableResolver;
import org.vafer.jdeb.utils.Utils;
import org.vafer.jdeb.utils.VariableResolver;

public class DebMojo
extends AbstractPluginMojo {
    private MavenProjectHelper projectHelper;
    private String namePattern;
    private File deb;
    private String debName;
    private File controlDir;
    private File changesIn = null;
    private String changesName;
    private File changesOut = null;
    private String installDir;
    private String openReplaceToken = "[[";
    private String closeReplaceToken = "]]";
    private String type;
    private String classifier;
    private Data[] dataSet;
    private Collection dataProducers = new ArrayList();

    public void setData(Data[] pData) {
        this.dataSet = pData;
        this.dataProducers.clear();
        if (pData != null) {
            for (int i = 0; i < pData.length; ++i) {
                this.dataProducers.add(pData[i]);
            }
        }
    }

    public void setOpenReplaceToken(String openReplaceToken) {
        this.openReplaceToken = openReplaceToken;
        AbstractDescriptor.setOpenToken(openReplaceToken);
    }

    public void setCloseReplaceToken(String closeReplaceToken) {
        this.closeReplaceToken = closeReplaceToken;
        AbstractDescriptor.setCloseToken(closeReplaceToken);
    }

    protected VariableResolver initializeVariableResolver(Map variables) {
        variables.put("name", this.getProject().getName());
        variables.put("artifactId", this.getProject().getArtifactId());
        variables.put("groupId", this.getProject().getGroupId());
        variables.put("version", this.getProject().getVersion().replace('-', '+'));
        variables.put("description", this.getProject().getDescription());
        variables.put("extension", "deb");
        return new MapVariableResolver(variables);
    }

    protected File getDebFile() {
        if (this.deb == null) {
            this.deb = new File(this.buildDirectory, this.debName);
        }
        return this.deb;
    }

    protected File getControlDir() {
        if (this.controlDir == null) {
            this.controlDir = new File(this.getProject().getBasedir(), "src/deb/control");
            this.getLog().info((CharSequence)("Using default path to control directory " + this.controlDir));
        }
        return this.controlDir;
    }

    protected File getControlFile() {
        return new File(this.controlDir, "control");
    }

    protected String getInstallDir() {
        if (this.installDir == null) {
            this.installDir = "/opt/" + this.getProject().getArtifactId();
            this.getLog().info((CharSequence)("Using default path to install directory " + this.installDir));
        }
        return this.installDir;
    }

    protected File getChangesInFile() {
        File f;
        if (this.changesIn == null && (f = new File(this.getProject().getBasedir(), "CHANGES.txt")).exists() && f.isFile() && f.canRead()) {
            this.changesIn = f;
        }
        return this.changesIn;
    }

    protected File getChangesOutFile() {
        if (this.changesOut == null) {
            this.changesOut = new File(this.buildDirectory, this.changesName);
        }
        return this.changesOut;
    }

    public void execute() throws MojoExecutionException {
        HashMap<String, String> variables = new HashMap<String, String>();
        VariableResolver resolver = this.initializeVariableResolver(variables);
        try {
            this.debName = Utils.replaceVariables(resolver, this.namePattern, this.openReplaceToken, this.closeReplaceToken);
            variables.put("extension", "changes");
            this.changesName = Utils.replaceVariables(resolver, this.namePattern, this.openReplaceToken, this.closeReplaceToken);
        }
        catch (ParseException e) {
            throw new MojoExecutionException("Failed parsing artifact name pattern", (Exception)e);
        }
        this.deb = this.getDebFile();
        this.changesIn = this.getChangesInFile();
        this.changesOut = this.getChangesOutFile();
        this.controlDir = this.getControlDir();
        this.setData(this.dataSet);
        if (this.dataProducers.isEmpty()) {
            final File file = this.getProject().getArtifact().getFile();
            this.dataProducers.add(new DataProducer(){

                public void produce(DataConsumer receiver) {
                    try {
                        receiver.onEachFile(new FileInputStream(file), new File(new File(DebMojo.this.getInstallDir()), file.getName()).getAbsolutePath(), "", "root", 0, "root", 0, 33188, file.length());
                    }
                    catch (Exception e) {
                        DebMojo.this.getLog().error((Throwable)e);
                    }
                }
            });
        }
        Console infoConsole = new Console(){

            public void println(String s) {
                DebMojo.this.getLog().info((CharSequence)s);
            }
        };
        try {
            DebMaker debMaker = new DebMaker(infoConsole, this.deb, this.controlDir, this.dataProducers, resolver);
            debMaker.makeDeb();
            this.getLog().info((CharSequence)("Attaching created debian archive " + this.deb));
            this.projectHelper.attachArtifact(this.getProject(), this.type, this.classifier, this.deb);
        }
        catch (PackagingException e) {
            this.getLog().error((CharSequence)("Failed to create debian package " + this.deb), (Throwable)e);
            throw new MojoExecutionException("Failed to create debian package " + this.deb, (Exception)e);
        }
    }
}

