/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.producers;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.tar.TarEntry;
import org.vafer.jdeb.DataConsumer;
import org.vafer.jdeb.DataProducer;
import org.vafer.jdeb.mapping.Mapper;
import org.vafer.jdeb.producers.AbstractDataProducer;
import org.vafer.jdeb.utils.Utils;

public final class DataProducerDirectory
extends AbstractDataProducer
implements DataProducer {
    private final DirectoryScanner scanner = new DirectoryScanner();

    public DataProducerDirectory(File pDir, String[] pIncludes, String[] pExcludes, Mapper[] pMappers) {
        super(pIncludes, pExcludes, pMappers);
        this.scanner.setBasedir(pDir);
        this.scanner.setIncludes(pIncludes);
        this.scanner.setExcludes(pExcludes);
        this.scanner.setCaseSensitive(true);
        this.scanner.setFollowSymlinks(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void produce(DataConsumer pReceiver) throws IOException {
        this.scanner.scan();
        File baseDir = this.scanner.getBasedir();
        String[] dirs = this.scanner.getIncludedDirectories();
        for (int i = 0; i < dirs.length; ++i) {
            File file = new File(baseDir, dirs[i]);
            String dirname = this.getFilename(baseDir, file);
            if ("".equals(dirname) || !this.isIncluded(dirname)) continue;
            if ('/' != File.separatorChar) {
                dirname = dirname.replace(File.separatorChar, '/');
            }
            if (!dirname.endsWith("/")) {
                dirname = dirname + "/";
            }
            TarEntry entry = new TarEntry(dirname);
            entry.setUserId(0);
            entry.setUserName("root");
            entry.setGroupId(0);
            entry.setGroupName("root");
            entry.setMode(16877);
            entry = this.map(entry);
            entry.setSize(0L);
            pReceiver.onEachDir(entry.getName(), entry.getLinkName(), entry.getUserName(), entry.getUserId(), entry.getGroupName(), entry.getGroupId(), entry.getMode(), entry.getSize());
        }
        String[] files = this.scanner.getIncludedFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = new File(baseDir, files[i]);
            String filename = this.getFilename(baseDir, file);
            if (!this.isIncluded(filename)) continue;
            if ('/' != File.separatorChar) {
                filename = filename.replace(File.separatorChar, '/');
            }
            TarEntry entry = new TarEntry(filename);
            entry.setUserId(0);
            entry.setUserName("root");
            entry.setGroupId(0);
            entry.setGroupName("root");
            entry.setMode(33188);
            entry = this.map(entry);
            entry.setSize(file.length());
            FileInputStream inputStream = new FileInputStream(file);
            try {
                pReceiver.onEachFile(inputStream, entry.getName(), entry.getLinkName(), entry.getUserName(), entry.getUserId(), entry.getGroupName(), entry.getGroupId(), entry.getMode(), entry.getSize());
                continue;
            }
            finally {
                ((InputStream)inputStream).close();
            }
        }
    }

    private String getFilename(File root, File file) {
        String relativeFilename = file.getAbsolutePath().substring(root.getAbsolutePath().length());
        return Utils.stripLeadingSlash(relativeFilename);
    }
}

