/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.shaded.compress.compress.archivers.zip;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import java.util.zip.ZipException;
import org.vafer.jdeb.shaded.compress.compress.archivers.ArchiveEntry;
import org.vafer.jdeb.shaded.compress.compress.archivers.ArchiveInputStream;
import org.vafer.jdeb.shaded.compress.compress.archivers.zip.ZipArchiveEntry;
import org.vafer.jdeb.shaded.compress.compress.archivers.zip.ZipArchiveOutputStream;
import org.vafer.jdeb.shaded.compress.compress.archivers.zip.ZipEncoding;
import org.vafer.jdeb.shaded.compress.compress.archivers.zip.ZipEncodingHelper;
import org.vafer.jdeb.shaded.compress.compress.archivers.zip.ZipLong;
import org.vafer.jdeb.shaded.compress.compress.archivers.zip.ZipShort;
import org.vafer.jdeb.shaded.compress.compress.archivers.zip.ZipUtil;

public class ZipArchiveInputStream
extends ArchiveInputStream {
    private static final int SHORT = 2;
    private static final int WORD = 4;
    private final ZipEncoding zipEncoding;
    private final boolean useUnicodeExtraFields;
    private final InputStream in;
    private final Inflater inf = new Inflater(true);
    private final CRC32 crc = new CRC32();
    private final byte[] buf = new byte[512];
    private ZipArchiveEntry current = null;
    private boolean closed = false;
    private boolean hitCentralDirectory = false;
    private int readBytesOfEntry = 0;
    private int offsetInBuffer = 0;
    private int bytesReadFromStream = 0;
    private int lengthOfLastRead = 0;
    private boolean hasDataDescriptor = false;
    private static final int LFH_LEN = 30;

    public ZipArchiveInputStream(InputStream inputStream) {
        this(inputStream, "UTF8", true);
    }

    public ZipArchiveInputStream(InputStream inputStream, String encoding, boolean useUnicodeExtraFields) {
        this.zipEncoding = ZipEncodingHelper.getZipEncoding(encoding);
        this.useUnicodeExtraFields = useUnicodeExtraFields;
        this.in = new PushbackInputStream(inputStream, this.buf.length);
    }

    public ZipArchiveEntry getNextZipEntry() throws IOException {
        if (this.closed || this.hitCentralDirectory) {
            return null;
        }
        if (this.current != null) {
            this.closeEntry();
        }
        byte[] lfh = new byte[30];
        try {
            this.readFully(lfh);
        }
        catch (EOFException e) {
            return null;
        }
        ZipLong sig = new ZipLong(lfh);
        if (sig.equals(ZipLong.CFH_SIG)) {
            this.hitCentralDirectory = true;
            return null;
        }
        if (!sig.equals(ZipLong.LFH_SIG)) {
            return null;
        }
        int off = 4;
        this.current = new ZipArchiveEntry();
        int versionMadeBy = ZipShort.getValue(lfh, off);
        this.current.setPlatform(versionMadeBy >> 8 & 0xF);
        int generalPurposeFlag = ZipShort.getValue(lfh, off += 2);
        boolean hasEFS = (generalPurposeFlag & 0x800) != 0;
        ZipEncoding entryEncoding = hasEFS ? ZipEncodingHelper.UTF8_ZIP_ENCODING : this.zipEncoding;
        this.hasDataDescriptor = (generalPurposeFlag & 8) != 0;
        this.current.setMethod(ZipShort.getValue(lfh, off += 2));
        long time = ZipUtil.dosToJavaTime(ZipLong.getValue(lfh, off += 2));
        this.current.setTime(time);
        off += 4;
        if (!this.hasDataDescriptor) {
            this.current.setCrc(ZipLong.getValue(lfh, off));
            this.current.setCompressedSize(ZipLong.getValue(lfh, off += 4));
            this.current.setSize(ZipLong.getValue(lfh, off += 4));
            off += 4;
        } else {
            off += 12;
        }
        int fileNameLen = ZipShort.getValue(lfh, off);
        int extraLen = ZipShort.getValue(lfh, off += 2);
        off += 2;
        byte[] fileName = new byte[fileNameLen];
        this.readFully(fileName);
        this.current.setName(entryEncoding.decode(fileName));
        byte[] extraData = new byte[extraLen];
        this.readFully(extraData);
        this.current.setExtra(extraData);
        if (!hasEFS && this.useUnicodeExtraFields) {
            ZipUtil.setNameAndCommentFromExtraFields(this.current, fileName, null);
        }
        return this.current;
    }

    public ArchiveEntry getNextEntry() throws IOException {
        return this.getNextZipEntry();
    }

    public int read(byte[] buffer, int start, int length) throws IOException {
        if (this.closed) {
            throw new IOException("The stream is closed");
        }
        if (this.inf.finished() || this.current == null) {
            return -1;
        }
        if (start <= buffer.length && length >= 0 && start >= 0 && buffer.length - start >= length) {
            if (this.current.getMethod() == 0) {
                int toRead;
                int csize = (int)this.current.getSize();
                if (this.readBytesOfEntry >= csize) {
                    return -1;
                }
                if (this.offsetInBuffer >= this.lengthOfLastRead) {
                    this.offsetInBuffer = 0;
                    this.lengthOfLastRead = this.in.read(this.buf);
                    if (this.lengthOfLastRead == -1) {
                        return -1;
                    }
                    this.count(this.lengthOfLastRead);
                    this.bytesReadFromStream += this.lengthOfLastRead;
                }
                int n = toRead = length > this.lengthOfLastRead ? this.lengthOfLastRead - this.offsetInBuffer : length;
                if (csize - this.readBytesOfEntry < toRead) {
                    toRead = csize - this.readBytesOfEntry;
                }
                System.arraycopy(this.buf, this.offsetInBuffer, buffer, start, toRead);
                this.offsetInBuffer += toRead;
                this.readBytesOfEntry += toRead;
                this.crc.update(buffer, start, toRead);
                return toRead;
            }
            if (this.inf.needsInput()) {
                this.fill();
                if (this.lengthOfLastRead > 0) {
                    this.bytesReadFromStream += this.lengthOfLastRead;
                }
            }
            int read = 0;
            try {
                read = this.inf.inflate(buffer, start, length);
            }
            catch (DataFormatException e) {
                throw new ZipException(e.getMessage());
            }
            if (read == 0 && this.inf.finished()) {
                return -1;
            }
            this.crc.update(buffer, start, read);
            return read;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.in.close();
        }
    }

    public long skip(long value) throws IOException {
        if (value >= 0L) {
            long skipped;
            int x;
            byte[] b = new byte[1024];
            for (skipped = 0L; skipped != value; skipped += (long)x) {
                long rem = value - skipped;
                x = this.read(b, 0, (int)((long)b.length > rem ? rem : (long)b.length));
                if (x != -1) continue;
                return skipped;
            }
            return skipped;
        }
        throw new IllegalArgumentException();
    }

    public static boolean matches(byte[] signature, int length) {
        if (length < ZipArchiveOutputStream.LFH_SIG.length) {
            return false;
        }
        return ZipArchiveInputStream.checksig(signature, ZipArchiveOutputStream.LFH_SIG) || ZipArchiveInputStream.checksig(signature, ZipArchiveOutputStream.EOCD_SIG);
    }

    private static boolean checksig(byte[] signature, byte[] expected) {
        for (int i = 0; i < expected.length; ++i) {
            if (signature[i] == expected[i]) continue;
            return false;
        }
        return true;
    }

    private void closeEntry() throws IOException {
        if (this.closed) {
            throw new IOException("The stream is closed");
        }
        if (this.current == null) {
            return;
        }
        this.skip(Long.MAX_VALUE);
        int inB = this.current.getMethod() == 8 ? this.inf.getTotalIn() : this.readBytesOfEntry;
        int diff = 0;
        diff = this.bytesReadFromStream - inB;
        if (diff != 0) {
            ((PushbackInputStream)this.in).unread(this.buf, this.lengthOfLastRead - diff, diff);
        }
        if (this.hasDataDescriptor) {
            this.readFully(new byte[16]);
        }
        this.inf.reset();
        this.lengthOfLastRead = 0;
        this.bytesReadFromStream = 0;
        this.offsetInBuffer = 0;
        this.readBytesOfEntry = 0;
        this.crc.reset();
        this.current = null;
    }

    private void fill() throws IOException {
        if (this.closed) {
            throw new IOException("The stream is closed");
        }
        this.lengthOfLastRead = this.in.read(this.buf);
        if (this.lengthOfLastRead > 0) {
            this.inf.setInput(this.buf, 0, this.lengthOfLastRead);
        }
    }

    private void readFully(byte[] b) throws IOException {
        int x = 0;
        for (int count = 0; count != b.length; count += x) {
            x = this.in.read(b, count, b.length - count);
            if (x != -1) continue;
            throw new EOFException();
        }
    }
}

