/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.shaded.compress.compress.archivers.zip;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipException;
import org.vafer.jdeb.shaded.compress.compress.archivers.zip.ZipArchiveEntry;
import org.vafer.jdeb.shaded.compress.compress.archivers.zip.ZipArchiveOutputStream;
import org.vafer.jdeb.shaded.compress.compress.archivers.zip.ZipEncoding;
import org.vafer.jdeb.shaded.compress.compress.archivers.zip.ZipEncodingHelper;
import org.vafer.jdeb.shaded.compress.compress.archivers.zip.ZipLong;
import org.vafer.jdeb.shaded.compress.compress.archivers.zip.ZipShort;
import org.vafer.jdeb.shaded.compress.compress.archivers.zip.ZipUtil;

public class ZipFile {
    private static final int HASH_SIZE = 509;
    private static final int SHORT = 2;
    private static final int WORD = 4;
    static final int NIBLET_MASK = 15;
    static final int BYTE_SHIFT = 8;
    private static final int POS_0 = 0;
    private static final int POS_1 = 1;
    private static final int POS_2 = 2;
    private static final int POS_3 = 3;
    private final Map entries = new HashMap(509);
    private final Map nameMap = new HashMap(509);
    private final String encoding;
    private final ZipEncoding zipEncoding;
    private final RandomAccessFile archive;
    private final boolean useUnicodeExtraFields;
    private static final int CFH_LEN = 42;
    private static final int MIN_EOCD_SIZE = 22;
    private static final int MAX_EOCD_SIZE = 65557;
    private static final int CFD_LOCATOR_OFFSET = 16;
    private static final long LFH_OFFSET_FOR_FILENAME_LENGTH = 26L;

    public ZipFile(File f) throws IOException {
        this(f, "UTF8");
    }

    public ZipFile(String name) throws IOException {
        this(new File(name), "UTF8");
    }

    public ZipFile(String name, String encoding) throws IOException {
        this(new File(name), encoding, true);
    }

    public ZipFile(File f, String encoding) throws IOException {
        this(f, encoding, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZipFile(File f, String encoding, boolean useUnicodeExtraFields) throws IOException {
        this.encoding = encoding;
        this.zipEncoding = ZipEncodingHelper.getZipEncoding(encoding);
        this.useUnicodeExtraFields = useUnicodeExtraFields;
        this.archive = new RandomAccessFile(f, "r");
        boolean success = false;
        try {
            Map entriesWithoutEFS = this.populateFromCentralDirectory();
            this.resolveLocalFileHeaderData(entriesWithoutEFS);
            success = true;
        }
        finally {
            if (!success) {
                try {
                    this.archive.close();
                }
                catch (IOException e2) {}
            }
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void close() throws IOException {
        this.archive.close();
    }

    public static void closeQuietly(ZipFile zipfile) {
        if (zipfile != null) {
            try {
                zipfile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public Enumeration getEntries() {
        return Collections.enumeration(this.entries.keySet());
    }

    public ZipArchiveEntry getEntry(String name) {
        return (ZipArchiveEntry)this.nameMap.get(name);
    }

    public InputStream getInputStream(ZipArchiveEntry ze) throws IOException, ZipException {
        OffsetEntry offsetEntry = (OffsetEntry)this.entries.get(ze);
        if (offsetEntry == null) {
            return null;
        }
        long start = offsetEntry.dataOffset;
        BoundedInputStream bis = new BoundedInputStream(start, ze.getCompressedSize());
        switch (ze.getMethod()) {
            case 0: {
                return bis;
            }
            case 8: {
                bis.addDummy();
                return new InflaterInputStream(bis, new Inflater(true));
            }
        }
        throw new ZipException("Found unsupported compression method " + ze.getMethod());
    }

    private Map populateFromCentralDirectory() throws IOException {
        HashMap<ZipArchiveEntry, NameAndComment> noEFS = new HashMap<ZipArchiveEntry, NameAndComment>();
        this.positionAtCentralDirectory();
        byte[] cfh = new byte[42];
        byte[] signatureBytes = new byte[4];
        this.archive.readFully(signatureBytes);
        long sig = ZipLong.getValue(signatureBytes);
        long cfhSig = ZipLong.getValue(ZipArchiveOutputStream.CFH_SIG);
        if (sig != cfhSig && this.startsWithLocalFileHeader()) {
            throw new IOException("central directory is empty, can't expand corrupt archive.");
        }
        while (sig == cfhSig) {
            this.archive.readFully(cfh);
            int off = 0;
            ZipArchiveEntry ze = new ZipArchiveEntry();
            int versionMadeBy = ZipShort.getValue(cfh, off);
            off += 2;
            ze.setPlatform(versionMadeBy >> 8 & 0xF);
            int generalPurposeFlag = ZipShort.getValue(cfh, off += 2);
            boolean hasEFS = (generalPurposeFlag & 0x800) != 0;
            ZipEncoding entryEncoding = hasEFS ? ZipEncodingHelper.UTF8_ZIP_ENCODING : this.zipEncoding;
            ze.setMethod(ZipShort.getValue(cfh, off += 2));
            long time = ZipUtil.dosToJavaTime(ZipLong.getValue(cfh, off += 2));
            ze.setTime(time);
            ze.setCrc(ZipLong.getValue(cfh, off += 4));
            ze.setCompressedSize(ZipLong.getValue(cfh, off += 4));
            ze.setSize(ZipLong.getValue(cfh, off += 4));
            int fileNameLen = ZipShort.getValue(cfh, off += 4);
            int extraLen = ZipShort.getValue(cfh, off += 2);
            int commentLen = ZipShort.getValue(cfh, off += 2);
            off += 2;
            ze.setInternalAttributes(ZipShort.getValue(cfh, off += 2));
            ze.setExternalAttributes(ZipLong.getValue(cfh, off += 2));
            byte[] fileName = new byte[fileNameLen];
            this.archive.readFully(fileName);
            ze.setName(entryEncoding.decode(fileName));
            OffsetEntry offset = new OffsetEntry();
            offset.headerOffset = ZipLong.getValue(cfh, off += 4);
            this.entries.put(ze, offset);
            this.nameMap.put(ze.getName(), ze);
            byte[] cdExtraData = new byte[extraLen];
            this.archive.readFully(cdExtraData);
            ze.setCentralDirectoryExtra(cdExtraData);
            byte[] comment = new byte[commentLen];
            this.archive.readFully(comment);
            ze.setComment(entryEncoding.decode(comment));
            this.archive.readFully(signatureBytes);
            sig = ZipLong.getValue(signatureBytes);
            if (hasEFS || !this.useUnicodeExtraFields) continue;
            noEFS.put(ze, new NameAndComment(fileName, comment));
        }
        return noEFS;
    }

    private void positionAtCentralDirectory() throws IOException {
        boolean found = false;
        long off = this.archive.length() - 22L;
        long stopSearching = Math.max(0L, this.archive.length() - 65557L);
        if (off >= 0L) {
            this.archive.seek(off);
            byte[] sig = ZipArchiveOutputStream.EOCD_SIG;
            int curr = this.archive.read();
            while (off >= stopSearching && curr != -1) {
                if (curr == sig[0] && (curr = this.archive.read()) == sig[1] && (curr = this.archive.read()) == sig[2] && (curr = this.archive.read()) == sig[3]) {
                    found = true;
                    break;
                }
                this.archive.seek(--off);
                curr = this.archive.read();
            }
        }
        if (!found) {
            throw new ZipException("archive is not a ZIP archive");
        }
        this.archive.seek(off + 16L);
        byte[] cfdOffset = new byte[4];
        this.archive.readFully(cfdOffset);
        this.archive.seek(ZipLong.getValue(cfdOffset));
    }

    private void resolveLocalFileHeaderData(Map entriesWithoutEFS) throws IOException {
        Enumeration e = this.getEntries();
        while (e.hasMoreElements()) {
            int skipped;
            ZipArchiveEntry ze = (ZipArchiveEntry)e.nextElement();
            OffsetEntry offsetEntry = (OffsetEntry)this.entries.get(ze);
            long offset = offsetEntry.headerOffset;
            this.archive.seek(offset + 26L);
            byte[] b = new byte[2];
            this.archive.readFully(b);
            int fileNameLen = ZipShort.getValue(b);
            this.archive.readFully(b);
            int extraFieldLen = ZipShort.getValue(b);
            for (int lenToSkip = fileNameLen; lenToSkip > 0; lenToSkip -= skipped) {
                skipped = this.archive.skipBytes(lenToSkip);
                if (skipped > 0) continue;
                throw new RuntimeException("failed to skip file name in local file header");
            }
            byte[] localExtraData = new byte[extraFieldLen];
            this.archive.readFully(localExtraData);
            ze.setExtra(localExtraData);
            offsetEntry.dataOffset = offset + 26L + 2L + 2L + (long)fileNameLen + (long)extraFieldLen;
            if (!entriesWithoutEFS.containsKey(ze)) continue;
            String orig = ze.getName();
            NameAndComment nc = (NameAndComment)entriesWithoutEFS.get(ze);
            ZipUtil.setNameAndCommentFromExtraFields(ze, nc.name, nc.comment);
            if (orig.equals(ze.getName())) continue;
            this.nameMap.remove(orig);
            this.nameMap.put(ze.getName(), ze);
        }
    }

    private boolean startsWithLocalFileHeader() throws IOException {
        this.archive.seek(0L);
        byte[] start = new byte[4];
        this.archive.readFully(start);
        for (int i = 0; i < start.length; ++i) {
            if (start[i] == ZipArchiveOutputStream.LFH_SIG[i]) continue;
            return false;
        }
        return true;
    }

    private static final class NameAndComment {
        private final byte[] name;
        private final byte[] comment;

        private NameAndComment(byte[] name, byte[] comment) {
            this.name = name;
            this.comment = comment;
        }
    }

    private class BoundedInputStream
    extends InputStream {
        private long remaining;
        private long loc;
        private boolean addDummyByte = false;

        BoundedInputStream(long start, long remaining) {
            this.remaining = remaining;
            this.loc = start;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read() throws IOException {
            if (this.remaining-- <= 0L) {
                if (this.addDummyByte) {
                    this.addDummyByte = false;
                    return 0;
                }
                return -1;
            }
            RandomAccessFile randomAccessFile = ZipFile.this.archive;
            synchronized (randomAccessFile) {
                ZipFile.this.archive.seek(this.loc++);
                return ZipFile.this.archive.read();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(byte[] b, int off, int len) throws IOException {
            if (this.remaining <= 0L) {
                if (this.addDummyByte) {
                    this.addDummyByte = false;
                    b[off] = 0;
                    return 1;
                }
                return -1;
            }
            if (len <= 0) {
                return 0;
            }
            if ((long)len > this.remaining) {
                len = (int)this.remaining;
            }
            int ret = -1;
            RandomAccessFile randomAccessFile = ZipFile.this.archive;
            synchronized (randomAccessFile) {
                ZipFile.this.archive.seek(this.loc);
                ret = ZipFile.this.archive.read(b, off, len);
            }
            if (ret > 0) {
                this.loc += (long)ret;
                this.remaining -= (long)ret;
            }
            return ret;
        }

        void addDummy() {
            this.addDummyByte = true;
        }
    }

    private static final class OffsetEntry {
        private long headerOffset = -1L;
        private long dataOffset = -1L;

        private OffsetEntry() {
        }
    }
}

