/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.shaded.compress.compress.changes;

import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.vafer.jdeb.shaded.compress.compress.archivers.ArchiveEntry;
import org.vafer.jdeb.shaded.compress.compress.changes.Change;

public final class ChangeSet {
    private final Set changes = new LinkedHashSet();

    public void delete(String filename) {
        this.addDeletion(new Change(filename, 1));
    }

    public void deleteDir(String dirName) {
        this.addDeletion(new Change(dirName, 4));
    }

    public void add(ArchiveEntry pEntry, InputStream pInput) {
        this.add(pEntry, pInput, true);
    }

    public void add(ArchiveEntry pEntry, InputStream pInput, boolean replace) {
        this.addAddition(new Change(pEntry, pInput, replace));
    }

    private void addAddition(Change pChange) {
        if (2 != pChange.type() || pChange.getInput() == null) {
            return;
        }
        if (!this.changes.isEmpty()) {
            Iterator it = this.changes.iterator();
            while (it.hasNext()) {
                ArchiveEntry entry;
                Change change = (Change)it.next();
                if (change.type() != 2 || change.getEntry() == null || !(entry = change.getEntry()).equals(pChange.getEntry())) continue;
                if (pChange.isReplaceMode()) {
                    it.remove();
                    this.changes.add(pChange);
                    return;
                }
                return;
            }
        }
        this.changes.add(pChange);
    }

    private void addDeletion(Change pChange) {
        if (1 != pChange.type() && 4 != pChange.type() || pChange.targetFile() == null) {
            return;
        }
        String source = pChange.targetFile();
        if (!this.changes.isEmpty()) {
            Iterator it = this.changes.iterator();
            while (it.hasNext()) {
                Change change = (Change)it.next();
                if (change.type() != 2 || change.getEntry() == null) continue;
                String target = change.getEntry().getName();
                if (1 == pChange.type() && source.equals(target)) {
                    it.remove();
                    continue;
                }
                if (4 != pChange.type() || !target.matches(source + "/.*")) continue;
                it.remove();
            }
        }
        this.changes.add(pChange);
    }

    Set getChanges() {
        return new LinkedHashSet(this.changes);
    }
}

