/*
 * Decompiled with CFR 0.152.
 */
package com.onaro.commons.exception;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;

public class NestedStackTraceException
extends Exception {
    private static final long serialVersionUID = 1L;
    private String nestedStackTrace;
    private String id;

    public NestedStackTraceException() {
        this.nestedStackTrace = "";
        this.id = "";
    }

    public NestedStackTraceException(String message) {
        super(message);
        this.nestedStackTrace = "";
        this.id = "";
    }

    public NestedStackTraceException(Throwable ex) {
        this.buildStackTrace(ex);
    }

    public NestedStackTraceException(String message, Throwable ex) {
        super(message);
        this.buildStackTrace(ex);
    }

    private void buildStackTrace(Throwable ex) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        ex.printStackTrace(printWriter);
        this.nestedStackTrace = stringWriter.toString();
        printWriter.close();
        StringBuilder str = new StringBuilder();
        Throwable cause = ex;
        while (cause != null && !(cause instanceof NestedStackTraceException)) {
            for (StackTraceElement stackTraceElement : cause.getStackTrace()) {
                if (stackTraceElement.getLineNumber() <= -1) continue;
                str.append(stackTraceElement.getLineNumber());
                break;
            }
            if ((cause = cause.getCause()) == null) continue;
            str.append('-');
        }
        if (cause != null) {
            str.append(((NestedStackTraceException)cause).getId());
            this.nestedStackTrace = this.nestedStackTrace + "\n Caused by:\n" + ((NestedStackTraceException)cause).getNestedStackTrace();
        }
        this.id = str.toString();
    }

    public String getNestedStackTrace() {
        return this.nestedStackTrace;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String toString() {
        String message = this.getLocalizedMessage();
        return this.getClass().getName() + (String)(this.id == null || this.id.length() == 0 ? "" : " [" + this.id + "]") + (String)(message == null || message.length() == 0 ? "" : "\n" + message);
    }

    @Override
    public void printStackTrace(PrintStream s) {
        s.println(this.toString());
        s.println(this.nestedStackTrace);
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        s.println(this.toString());
        s.println(this.nestedStackTrace);
    }
}

