/*
 * Decompiled with CFR 0.152.
 */
package com.onaro.commons.framework.mgmt;

import com.onaro.commons.AuProperties;
import com.onaro.commons.exception.ConfigurationException;
import com.onaro.commons.framework.mgmt.BasicHttpBasedUrlConnection;
import com.onaro.commons.util.HttpURLConnectionUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Properties;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLException;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcquisitionHttpClientConnectionManager {
    private static final Logger logger = LoggerFactory.getLogger(AcquisitionHttpClientConnectionManager.class);
    private static final String ACQ_HOME = System.getProperty("acq.home");
    private static final String GENERAL_PROPERTIES_FILE = "general.properties";
    private static final int CONNECTION_TIMEOUT_IN_MS = Integer.parseInt(AcquisitionHttpClientConnectionManager.getValueFromGeneralProperties("CONNECTION_TIMEOUT_IN_MS", "1500"));
    private static final int READ_TIMEOUT_IN_MS = Integer.parseInt(AcquisitionHttpClientConnectionManager.getValueFromGeneralProperties("READ_TIMEOUT_IN_MS", "0"));
    private static final int DEFAULT_CERT_DOWNLOAD_TIMEOUT_IN_MS = 60000;
    private static final String DEFAULT_USERNAME = "acquisition";
    private static String jSessionId = "";
    private final BasicHttpBasedUrlConnection httpConnection = BasicHttpBasedUrlConnection.getInstance();
    private static final AcquisitionHttpClientConnectionManager acquisitionHttpClientConnectionManager = new AcquisitionHttpClientConnectionManager();

    private AcquisitionHttpClientConnectionManager() {
        try {
            this.httpConnection.initSSL();
        }
        catch (ConfigurationException ex) {
            new RuntimeException("AcquisitionHttpClientConnectionManager could not be initialized", ex);
        }
    }

    public static AcquisitionHttpClientConnectionManager getInstance() {
        return acquisitionHttpClientConnectionManager;
    }

    private HttpsURLConnection createBasicHTTPSConnection(String ip, Integer port, String resourcePath, String user, String password, String method, String contentType, String requestObject) throws IOException, ConfigurationException {
        URL url = null;
        url = ip != null && port != null ? new URL("https", ip, port, resourcePath) : new URL(System.getProperty("codebase") + resourcePath);
        HttpsURLConnection con = null;
        con = (HttpsURLConnection)this.httpConnection.openHttpConnection(url, 60000, false);
        this.setConnectionProperties(con, user, password, method, contentType, requestObject);
        try {
            con.connect();
        }
        catch (SSLException ex) {
            logger.error(String.format("Certificate error for cluster with host %s %s", url.getHost(), ex.getMessage()));
            con = (HttpsURLConnection)this.httpConnection.openHttpConnection(url, 60000, true);
            this.setConnectionProperties(con, user, password, method, contentType, requestObject);
            con.connect();
        }
        logger.debug(String.format("Https Connection created to host %s and port %d for %s execution ", url.getHost(), url.getPort(), method));
        return con;
    }

    private void setConnectionProperties(HttpsURLConnection con, String user, String password, String method, String contentType, String requestObject) throws IOException {
        String auPropsPasssword = AuProperties.getAuProperties().getProperty("acquisition.password");
        StringBuilder sb = new StringBuilder(user == null ? DEFAULT_USERNAME : user).append(":").append(password == null ? auPropsPasssword : password);
        String base64UserPass = Base64.getEncoder().encodeToString(sb.toString().getBytes(StandardCharsets.UTF_8));
        con.addRequestProperty("Authorization", "Basic " + base64UserPass);
        if (!jSessionId.isEmpty()) {
            con.setRequestProperty("Cookie", jSessionId);
        }
        con.setRequestMethod(method);
        con.setConnectTimeout(CONNECTION_TIMEOUT_IN_MS);
        con.setReadTimeout(READ_TIMEOUT_IN_MS);
        con.setRequestProperty("Accept", contentType);
        con.setRequestProperty("Content-Type", contentType);
        con.setRequestProperty("Accept-Encoding", contentType);
        con.setRequestProperty("Connection", "keep-alive");
        con.setUseCaches(false);
        con.setDoInput(true);
        con.setDoOutput(true);
        if (("POST".equalsIgnoreCase(method) || "PATCH".equalsIgnoreCase(method)) && (requestObject == null || requestObject.isBlank())) {
            con.setDoOutput(false);
            con.setRequestProperty("Content-Length", "0");
            return;
        }
        if (requestObject != null && !requestObject.isBlank()) {
            OutputStream os = con.getOutputStream();
            os.write(requestObject.getBytes(StandardCharsets.UTF_8));
        }
    }

    private HttpsURLConnection createBasicHTTPSConnection(String ip, Integer port, String resourcePath, String user, String password, String method, JSONObject requestObject) throws IOException, ConfigurationException {
        return this.createBasicHTTPSConnection(ip, port, resourcePath, user, password, method, "application/json", requestObject == null ? "" : requestObject.toString());
    }

    public HttpsURLConnection executeHTTPSPOSTAcquisitionAPI(String ip, Integer port, String resourcePath, String user, String password, JSONObject requestObject) throws IOException, ConfigurationException {
        HttpsURLConnection con = this.createBasicHTTPSConnection(ip, port, resourcePath, user, password, "POST", requestObject);
        this.setCurrentJsessionId(con);
        logger.debug(String.format("Executed %s on REST API %s ", "POST", resourcePath));
        return con;
    }

    public HttpsURLConnection executeHTTPSPOSTAcquisitionAPI(String ip, Integer port, String resourcePath, String user, String password, String requestObject) throws IOException, ConfigurationException {
        HttpsURLConnection con = this.createBasicHTTPSConnection(ip, port, resourcePath, user, password, "POST", "application/json", requestObject);
        this.setCurrentJsessionId(con);
        logger.debug(String.format("Executed %s on REST API %s ", "POST", resourcePath));
        return con;
    }

    public HttpsURLConnection executeHTTPSPOSTAcquisitionAPI(String resourcePath, JSONObject requestObject) throws IOException, ConfigurationException {
        return this.executeHTTPSPOSTAcquisitionAPI(null, null, resourcePath, null, null, requestObject);
    }

    public HttpsURLConnection executeHTTPSPOSTAcquisitionAPI(String resourcePath, String requestObject) throws IOException, ConfigurationException {
        return this.executeHTTPSPOSTAcquisitionAPI(null, null, resourcePath, null, null, requestObject);
    }

    public HttpsURLConnection executeHTTPSPOSTAcquisitionAPI(String ip, Integer port, String resourcePath, JSONObject requestObject) throws IOException, ConfigurationException {
        return this.executeHTTPSPOSTAcquisitionAPI(ip, port, resourcePath, null, null, requestObject);
    }

    public HttpsURLConnection executeHTTPSPOSTAcquisitionAPI(String ip, Integer port, String resourcePath, String requestObject) throws IOException, ConfigurationException {
        return this.executeHTTPSPOSTAcquisitionAPI(ip, port, resourcePath, null, null, requestObject);
    }

    public HttpsURLConnection executeHTTPSPOSTAcquisitionAPI(String resourcePath) throws IOException, ConfigurationException {
        return this.executeHTTPSPOSTAcquisitionAPI(null, null, resourcePath, null, null, "");
    }

    public HttpsURLConnection executeHTTPSGETAcquisitionAPI(String ip, Integer port, String resourcePath, String user, String password) throws IOException, ConfigurationException {
        HttpsURLConnection con = this.createBasicHTTPSConnection(ip, port, resourcePath, user, password, "GET", "application/json", "");
        this.setCurrentJsessionId(con);
        logger.debug(String.format("Executed %s on REST API %s ", "GET", resourcePath));
        return con;
    }

    public HttpsURLConnection executeHTTPSGETAcquisitionAPI(String resourcePath) throws IOException, ConfigurationException {
        return this.executeHTTPSGETAcquisitionAPI(null, null, resourcePath, null, null);
    }

    public HttpsURLConnection executeHTTPSGETAcquisitionAPI(String ip, Integer port, String resourcePath) throws IOException, ConfigurationException {
        return this.executeHTTPSGETAcquisitionAPI(ip, port, resourcePath, null, null);
    }

    public HttpsURLConnection executeHTTPSDELETEAcquisitionAPI(String ip, Integer port, String resourcePath, String user, String password) throws IOException, ConfigurationException {
        HttpsURLConnection con = this.createBasicHTTPSConnection(ip, port, resourcePath, user, password, "DELETE", "application/json", "");
        this.setCurrentJsessionId(con);
        logger.debug(String.format("Executed %s on REST API %s ", "DELETE", resourcePath));
        return con;
    }

    public HttpsURLConnection executeHTTPSDELETEAcquisitionAPI(String resourcePath) throws IOException, ConfigurationException {
        return this.executeHTTPSDELETEAcquisitionAPI(null, null, resourcePath, null, null);
    }

    public HttpsURLConnection executeHTTPSDELETEAcquisitionAPI(String ip, Integer port, String resourcePath) throws IOException, ConfigurationException {
        return this.executeHTTPSDELETEAcquisitionAPI(ip, port, resourcePath, null, null);
    }

    public HttpsURLConnection executeHTTPSPATCHAcquisitionAPI(String ip, Integer port, String resourcePath, String user, String password, JSONObject requestObject) throws IOException, ConfigurationException {
        HttpsURLConnection con = this.createBasicHTTPSConnection(ip, port, resourcePath, user, password, "PATCH", requestObject);
        this.setCurrentJsessionId(con);
        logger.debug(String.format("Executed %s on REST API %s ", "PATCH", resourcePath));
        return con;
    }

    public HttpsURLConnection executeHTTPSPATCHAcquisitionAPI(String ip, Integer port, String resourcePath, String user, String password, String requestObject) throws IOException, ConfigurationException {
        HttpsURLConnection con = this.createBasicHTTPSConnection(ip, port, resourcePath, user, password, "PATCH", "application/json", requestObject);
        this.setCurrentJsessionId(con);
        logger.debug(String.format("Executed %s on REST API %s ", "PATCH", resourcePath));
        return con;
    }

    public HttpsURLConnection executeHTTPSPATCHAcquisitionAPI(String resourcePath, JSONObject requestObject) throws IOException, ConfigurationException {
        return this.executeHTTPSPATCHAcquisitionAPI(null, null, resourcePath, null, null, requestObject);
    }

    public HttpsURLConnection executeHTTPSPATCHAcquisitionAPI(String resourcePath, String requestObject) throws IOException, ConfigurationException {
        return this.executeHTTPSPATCHAcquisitionAPI(null, null, resourcePath, null, null, requestObject);
    }

    public HttpsURLConnection executeHTTPSPATCHAcquisitionAPI(String ip, Integer port, String resourcePath, JSONObject requestObject) throws IOException, ConfigurationException {
        return this.executeHTTPSPATCHAcquisitionAPI(ip, port, resourcePath, null, null, requestObject);
    }

    public HttpsURLConnection executeHTTPSPATCHAcquisitionAPI(String resourcePath) throws IOException, ConfigurationException {
        return this.executeHTTPSPATCHAcquisitionAPI(null, null, resourcePath, null, null, "");
    }

    private void setCurrentJsessionId(HttpsURLConnection urlConnection) throws IOException {
        String currJessionId = HttpURLConnectionUtils.getJsesionIdCookie(urlConnection);
        if (urlConnection.getResponseCode() == 200 && currJessionId != null) {
            jSessionId = currJessionId;
        }
    }

    public static String getValueFromGeneralProperties(String key, String defaultValue) {
        String value = defaultValue;
        Properties prop = new Properties();
        String generalPropertiesFilePath = (ACQ_HOME == null || ACQ_HOME.isEmpty() ? "/opt/netapp/essentials/au" : ACQ_HOME).concat(File.separator).concat("conf").concat(File.separator).concat("preferences").concat(File.separator).concat(GENERAL_PROPERTIES_FILE);
        try {
            prop.load(new FileInputStream(generalPropertiesFilePath));
            if (prop.getProperty(key) != null) {
                value = prop.getProperty(key);
            }
        }
        catch (Exception e) {
            logger.error("Unable to load value of {} from file {}: {} ", key, GENERAL_PROPERTIES_FILE, e);
        }
        return value;
    }
}

