/*
 * Decompiled with CFR 0.152.
 */
package com.onaro.commons.metrics;

import com.codahale.metrics.json.MetricsModule;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.onaro.commons.metrics.MetricsRegistryProvider;
import com.onaro.commons.metrics.executor.ScheduledThreadPoolMonitorExecutor;
import com.onaro.commons.metrics.executor.ThreadPoolScope;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MetricMonitorLogger {
    private static final String LOGGER_NAME = "metrics";
    private static final Logger logger = LoggerFactory.getLogger("metrics");
    private static final Logger errorLogger = LoggerFactory.getLogger(MetricMonitorLogger.class);
    private static final ObjectMapper JSONMAPPER = new ObjectMapper();
    private static final ScheduledExecutorService metricScheduler = ScheduledThreadPoolMonitorExecutor.newSingleThreadScheduledExecutor("metric-logger-pool", ThreadPoolScope.GLOBAL);

    public static void init() {
        JSONMAPPER.registerModule(new MetricsModule(TimeUnit.MILLISECONDS, TimeUnit.MILLISECONDS, false));
        metricScheduler.scheduleAtFixedRate(() -> MetricMonitorLogger.reportThreadPoolMetricStats(), 0L, 1L, TimeUnit.HOURS);
    }

    public static void reportThreadPoolMetricStats() {
        String metricsJson = MetricMonitorLogger.metricAsJson();
        logger.info(metricsJson);
    }

    public static String metricAsJson() {
        Map map = MetricsRegistryProvider.getMetricRegistryNames().stream().collect(Collectors.toMap(Function.identity(), MetricsRegistryProvider::getMetricRegistry));
        TreeMap registryMetricDataMap = new TreeMap(map);
        try {
            return JSONMAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(registryMetricDataMap);
        }
        catch (JsonProcessingException e) {
            errorLogger.error("Error while fetching registry metric data", e);
            return "";
        }
    }
}

