/*
 * Decompiled with CFR 0.152.
 */
package com.onaro.commons.table;

import java.util.prefs.Preferences;

public class DbConfig {
    private static final String DB_SYSTEM_NODE = "/com/onaro/sanscreen/server/db";
    public static final String MYSQL_HOST_DEFAULT_VALUE = "localhost";
    public static final String NAME_KEY = ".name";
    private static final String MYSQL_HOST_KEY = "mysql.host";

    public static String getSanscreenDbName() {
        String schema = Schema.SANSCREEN.name().toLowerCase();
        return DbConfig.getRegistryNode().get(schema + NAME_KEY, schema);
    }

    public static String getAcquisitionDbName() {
        String schema = Schema.ACQUISITION.name().toLowerCase();
        return DbConfig.getRegistryNode().get(schema + NAME_KEY, schema);
    }

    public static String getManagementDbName() {
        String schema = Schema.MANAGEMENT.name().toLowerCase();
        return DbConfig.getRegistryNode().get(schema + NAME_KEY, schema);
    }

    public static String getMySqlHost() {
        return DbConfig.getRegistryNode().get(MYSQL_HOST_KEY, MYSQL_HOST_DEFAULT_VALUE);
    }

    public static void setMySqlHost(String mySqlHost) {
        DbConfig.getRegistryNode().put(MYSQL_HOST_KEY, mySqlHost);
    }

    public static void setDatabasePrefix(String prefix) {
        prefix = prefix == null || prefix.length() == 0 ? "" : prefix + "_";
        for (Schema schema : Schema.values()) {
            String schemaName = prefix + schema.name().toLowerCase();
            String schemaKey = schemaName + NAME_KEY;
            DbConfig.getRegistryNode().put(schemaKey, schemaName);
        }
    }

    private static Preferences getRegistryNode() {
        return Preferences.systemRoot().node(DB_SYSTEM_NODE);
    }

    static enum Schema {
        SANSCREEN,
        ACQUISITION,
        MANAGEMENT;

    }
}

