/*
 * Decompiled with CFR 0.152.
 */
package com.onaro.commons.types;

import com.onaro.commons.types.AbstractType;
import java.util.Collection;

public class Period
extends AbstractType {
    private static final long serialVersionUID = 1L;
    public static final Period SECOND = new Period(0, "SECOND", 1000L, null);
    public static final Period MINUTE = new Period(1, "MINUTE", Period.SECOND.milliseconds * 60L, null);
    public static final Period HOUR = new Period(2, "HOUR", Period.MINUTE.milliseconds * 60L, MINUTE);
    public static final Period DAY = new Period(3, "DAY", Period.HOUR.milliseconds * 24L, HOUR);
    public static final Period WEEK = new Period(4, "WEEK", Period.DAY.milliseconds * 7L, DAY);
    public static final Period MONTH = new Period(5, "MONTH", Period.DAY.milliseconds * 31L, DAY);
    public static final Period YEAR = new Period(6, "YEAR", Period.MONTH.milliseconds * 12L, MONTH);
    private long milliseconds;
    private Period resolutionPeriod;

    private Period(int typeId, String name, long inMilliSeconds, Period resolutionPeriod) {
        super(Period.class, typeId, name);
        this.milliseconds = inMilliSeconds;
        this.resolutionPeriod = resolutionPeriod;
    }

    public static Period getById(int typeId) {
        return Period.getById(Period.class, typeId);
    }

    public static Period getByName(String name) {
        return Period.getByName(Period.class, name);
    }

    public static Period getByNameIgnoreCase(String name) {
        return Period.getByNameIgnoreCase(Period.class, name);
    }

    public static Collection<Period> getAll() {
        return Period.getAll(Period.class);
    }

    public long milliseconds() {
        return this.milliseconds;
    }

    public long subtract(long time) {
        return time - this.milliseconds();
    }

    public long add(long time) {
        return time + this.milliseconds();
    }

    public long subtract(long time, int count) {
        return time - (long)count * this.milliseconds();
    }

    public long add(long time, int count) {
        return time + (long)count * this.milliseconds();
    }

    public Period getResolutionPeriod() {
        return this.resolutionPeriod;
    }
}

