/*
 * Decompiled with CFR 0.152.
 */
package com.onaro.commons.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Writer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static final Logger logger = LoggerFactory.getLogger(FileUtils.class);
    private static int MAX_COUNT = 67076096;
    private static TempDirCount TEMP_DIR_COUNTER = new TempDirCount();
    public static final String UTF_8 = "utf-8";
    private static final String ONARO_HOME_DIR = System.getProperty("onaro.home");
    private static final String LOG_COLLECTION_OBJECTS = System.getProperty("log.collection.objects");
    private static final String SERVER_PROPERTIES_FILE = "server.properties";
    private static final String SERVER_PROPERTIES_CHECK_CLOUDAGENT_ENABLED = "enable.cloudagent";
    private static final String SERVER_PROPERTIES_JBOSS_PASSWORD = "jboss.password";
    public static final String SERVER_PROPERTIES_BASELINE_TIMEOUT = "collection.baseline_timeout";
    public static final String SERVER_PROPERTIES_COUNTERS_TIMEOUT = "collection.counters_timeout";
    public static final String SERVER_PROPERTIES_CLOUD_AGENT_TTL = "cloud_agent.ttl_in_minutes";
    private static String ZAPI_DEBUG_FILE;
    private static String REST_DEBUG_FILE;
    private static Boolean IS_CLOUD_AGENT_ENABLED;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File in, File out) throws IOException {
        FileChannel inChannel = new FileInputStream(in).getChannel();
        FileChannel outChannel = new FileOutputStream(out, true).getChannel();
        try {
            long size = inChannel.size();
            for (long position = 0L; position < size; position += inChannel.transferTo(position, MAX_COUNT, outChannel)) {
            }
        }
        finally {
            if (inChannel != null) {
                inChannel.close();
            }
            if (outChannel != null) {
                outChannel.close();
            }
        }
    }

    public static boolean deleteDir(File directory, Logger logger) {
        if (directory != null && directory.exists() && directory.isDirectory()) {
            FileUtils.deleteDirContent(directory, logger);
            boolean deleted = directory.delete();
            if (!deleted && logger != null) {
                logger.warn("Failed to delete direcotry '" + directory + "'.");
            }
            return deleted;
        }
        return false;
    }

    public static List<File> deleteDirContent(File directory, Logger logger) {
        return FileUtils.deleteDirContent(directory, null, logger);
    }

    public static List<File> deleteDirContent(File directory, FileFilter filter, Logger logger) {
        if (directory != null && directory.exists() && directory.isDirectory()) {
            ArrayList<File> filesFailedToDelete = new ArrayList<File>();
            for (File file : directory.listFiles(filter)) {
                boolean deleted;
                if (file.isDirectory()) {
                    filesFailedToDelete.addAll(FileUtils.deleteDirContent(file, filter, null));
                }
                if (deleted = file.delete()) continue;
                filesFailedToDelete.add(file);
            }
            if (logger != null && !filesFailedToDelete.isEmpty()) {
                logger.warn("Failed to delete content of direcotry '" + directory + "'. The following files inside the directory could not be deleted :" + filesFailedToDelete);
            }
            return filesFailedToDelete;
        }
        return Collections.emptyList();
    }

    public static File createTempDir(File parentDir, String prefix) throws IOException {
        if (parentDir != null) {
            File tempDir = new File(parentDir, prefix + TEMP_DIR_COUNTER.inc());
            tempDir.deleteOnExit();
            boolean created = tempDir.mkdirs();
            if (created) {
                return tempDir;
            }
            throw new IOException("Failed to create temporary directory '" + tempDir + "'");
        }
        throw new IOException("Failed to create temporary directory. Parent directory is not specified.");
    }

    public static List<String> readLinesFromFile(File file) throws IOException {
        try (InputStreamReader fileReader = new InputStreamReader(new FileInputStream(file));){
            List<String> list = FileUtils.readLines(fileReader);
            return list;
        }
    }

    public static List<String> readLines(Reader input) throws IOException {
        BufferedReader reader = new BufferedReader(input);
        ArrayList<String> list = new ArrayList<String>();
        String line = reader.readLine();
        while (line != null) {
            list.add(line);
            line = reader.readLine();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readEntireFile(File file) throws IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        if (randomAccessFile.length() <= Integer.MAX_VALUE) {
            try {
                int readThisTime;
                int fileSize = (int)randomAccessFile.length();
                byte[] bytes = new byte[fileSize];
                for (int readSoFar = 0; readSoFar < fileSize; readSoFar += readThisTime) {
                    readThisTime = randomAccessFile.read(bytes, readSoFar, fileSize - readSoFar);
                    if (readThisTime > -1) {
                        continue;
                    }
                    throw new IOException("Unexpected EOF. Only " + readSoFar + " bytes read. File size is " + fileSize);
                }
                byte[] byArray = bytes;
                return byArray;
            }
            finally {
                randomAccessFile.close();
            }
        }
        throw new IOException("File too big");
    }

    public static String readEntireTextFile(File file, String charset) throws IOException {
        return new String(FileUtils.readEntireFile(file), charset);
    }

    public static String readEntireTextFile(File file) throws IOException {
        return FileUtils.readEntireTextFile(file, UTF_8);
    }

    public static String readEntireTextStream(InputStream in) throws IOException {
        int readLen;
        char[] chars = new char[1024];
        InputStreamReader reader = new InputStreamReader(in, UTF_8);
        StringBuilder sb = new StringBuilder();
        while ((readLen = reader.read(chars)) != -1) {
            sb.append(chars, 0, readLen);
        }
        in.close();
        return sb.toString();
    }

    public static void writeStringIntoAFile(String content, File file, boolean append, String charset) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file, append), charset);
        writer.write(content);
        ((Writer)writer).close();
    }

    public static void writeStringIntoAFile(String content, File file) throws IOException {
        FileUtils.writeStringIntoAFile(content, file, false, UTF_8);
    }

    public static Writer createUtf8FileWriter(File file) throws IOException {
        return new OutputStreamWriter((OutputStream)new FileOutputStream(file), UTF_8);
    }

    public static Reader createUtf8FileReader(File file) throws IOException {
        return new InputStreamReader((InputStream)new FileInputStream(file), UTF_8);
    }

    private static String getServerProperty(String property) {
        Properties prop = new Properties();
        String serverPropertiesFilePath = !ONARO_HOME_DIR.isEmpty() ? ONARO_HOME_DIR.concat(File.separator).concat("conf").concat(File.separator).concat(SERVER_PROPERTIES_FILE) : "";
        String foundProperty = null;
        try {
            prop.load(new FileInputStream(serverPropertiesFilePath));
            foundProperty = prop.getProperty(property);
        }
        catch (Exception e) {
            logger.error("Unable to load value of {} from file {}: {} ", property, SERVER_PROPERTIES_FILE, e);
        }
        return foundProperty;
    }

    public static Integer getCloudAgentTTL() {
        String caTTL = FileUtils.getServerProperty(SERVER_PROPERTIES_CLOUD_AGENT_TTL);
        if (caTTL != null) {
            return Integer.valueOf(caTTL);
        }
        return null;
    }

    public static boolean checkCloudAgentEnabled() {
        if (IS_CLOUD_AGENT_ENABLED != null) {
            return IS_CLOUD_AGENT_ENABLED;
        }
        String cloudAgentEnabled = FileUtils.getServerProperty(SERVER_PROPERTIES_CHECK_CLOUDAGENT_ENABLED);
        if (cloudAgentEnabled != null && cloudAgentEnabled.equals("true")) {
            IS_CLOUD_AGENT_ENABLED = Boolean.TRUE;
            return IS_CLOUD_AGENT_ENABLED;
        }
        IS_CLOUD_AGENT_ENABLED = Boolean.FALSE;
        return IS_CLOUD_AGENT_ENABLED;
    }

    public static String retrievePassword() {
        Properties prop = new Properties();
        String serverPropertiesFilePath = !ONARO_HOME_DIR.isEmpty() ? ONARO_HOME_DIR.concat(File.separator).concat("conf").concat(File.separator).concat(SERVER_PROPERTIES_FILE) : "";
        String jbossPassword = "";
        try {
            prop.load(new FileInputStream(serverPropertiesFilePath));
            jbossPassword = prop.getProperty(SERVER_PROPERTIES_JBOSS_PASSWORD);
        }
        catch (Exception e) {
            logger.error("Unable to read from file {}: {} ", (Object)SERVER_PROPERTIES_FILE, (Object)e);
        }
        if (jbossPassword != null) {
            return jbossPassword;
        }
        return "";
    }

    public static String getStringServerProperty(String property) {
        Properties prop = new Properties();
        String serverPropertiesFilePath = !ONARO_HOME_DIR.isEmpty() ? ONARO_HOME_DIR.concat(File.separator).concat("conf").concat(File.separator).concat(SERVER_PROPERTIES_FILE) : "";
        String result = "";
        try {
            prop.load(new FileInputStream(serverPropertiesFilePath));
            result = prop.getProperty(property);
        }
        catch (Exception e) {
            logger.error("Unable to read from file {}: {} ", (Object)SERVER_PROPERTIES_FILE, (Object)e);
        }
        if (result != null) {
            return result;
        }
        return "";
    }

    public static boolean isObjectLoggingEnabled() {
        if (LOG_COLLECTION_OBJECTS == null) {
            return false;
        }
        return LOG_COLLECTION_OBJECTS.equals("true");
    }

    public static synchronized void writeToZapiDebug(String msg) {
        FileUtils.writeToFile(msg, ZAPI_DEBUG_FILE);
    }

    public static synchronized void writeToRestDebug(String msg) {
        FileUtils.writeToFile(msg, REST_DEBUG_FILE);
    }

    private static void writeToFile(String msg, String fileName) {
        try {
            File outFile = new File(fileName);
            if (!outFile.exists()) {
                outFile.createNewFile();
            }
            FileWriter w = new FileWriter(outFile, true);
            w.write(msg);
            w.close();
        }
        catch (Exception e) {
            logger.error("Failed to write to file", e);
        }
    }

    static {
        if (ONARO_HOME_DIR != null) {
            ZAPI_DEBUG_FILE = ONARO_HOME_DIR.concat(File.separator).concat("..").concat(File.separator).concat("ocum").concat(File.separator).concat("zapiDebug.log");
            REST_DEBUG_FILE = ONARO_HOME_DIR.concat(File.separator).concat("..").concat(File.separator).concat("ocum").concat(File.separator).concat("restDebug.log");
        }
        IS_CLOUD_AGENT_ENABLED = null;
    }

    private static class TempDirCount {
        private int counter = new Random().nextInt() & 0xFFFF;

        private TempDirCount() {
        }

        public synchronized int inc() {
            return this.counter++;
        }
    }
}

