/*
 * Decompiled with CFR 0.152.
 */
package com.onaro.commons.util;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.Map;

public final class ObjectUtils {
    private static final int SEED_HASH_CODE = 255;
    private static final int NULL_HASH_CODE = 15;

    private ObjectUtils() {
    }

    @Deprecated
    public static boolean isEqual(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }

    public static int hashCode(Iterable<?> iter) {
        int hashCode = 255;
        for (Object obj : iter) {
            int subHashCode = 15;
            if (obj != null) {
                subHashCode = obj.hashCode();
            }
            hashCode = 63 * hashCode + subHashCode;
        }
        return hashCode;
    }

    public static int hashCode(Object ... args) {
        return ObjectUtils.hashCode(Arrays.asList(args));
    }

    public static <T extends Enum<T>> T safeEnumValueOf(String name, T defaultValue) {
        T result;
        block4: {
            result = defaultValue;
            Class<T> clazz = defaultValue.getDeclaringClass();
            try {
                result = Enum.valueOf(clazz, name);
            }
            catch (IllegalArgumentException e) {
                if (name == null) break block4;
                try {
                    result = Enum.valueOf(clazz, name.toUpperCase());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    public static <T> T deepClone(T srcObj) throws CloneNotSupportedException {
        if (srcObj == null) {
            return null;
        }
        IdentityHashMap<Object, Object> cachedObjects = new IdentityHashMap<Object, Object>();
        return ObjectUtils.deepClone(srcObj, cachedObjects);
    }

    public static <T> T shallowClone(T srcObj) throws CloneNotSupportedException {
        if (srcObj == null) {
            return null;
        }
        try {
            Class<?> srcObjClass = srcObj.getClass();
            Method cloneMethod = srcObjClass.getMethod("clone", new Class[0]);
            if (cloneMethod.getDeclaringClass().equals(Object.class)) {
                throw new CloneNotSupportedException();
            }
            Object clonedObj = cloneMethod.invoke(srcObj, new Object[0]);
            return (T)clonedObj;
        }
        catch (Exception e) {
            CloneNotSupportedException cnse = new CloneNotSupportedException();
            cnse.initCause(e);
            throw cnse;
        }
    }

    private static <T, C extends Collection<T>> C deepCloneCollection(C collection, IdentityHashMap<Object, Object> cachedObjects) throws CloneNotSupportedException {
        if (collection == null) {
            return null;
        }
        try {
            C newCollection = ObjectUtils.shallowClone(collection);
            newCollection.clear();
            for (T element : collection) {
                if (element == null) {
                    newCollection.add(null);
                    continue;
                }
                newCollection.add(ObjectUtils.deepClone(element, cachedObjects));
            }
            return newCollection;
        }
        catch (Exception e) {
            CloneNotSupportedException ex = new CloneNotSupportedException();
            ex.initCause(e);
            throw ex;
        }
    }

    private static <K, V, M extends Map<K, V>> M deepCloneMap(M map, IdentityHashMap<Object, Object> cachedObjects) throws CloneNotSupportedException {
        if (map == null) {
            return null;
        }
        try {
            M newMap = ObjectUtils.shallowClone(map);
            newMap.clear();
            for (Map.Entry<K, V> entry : map.entrySet()) {
                K clonedKey = ObjectUtils.deepClone(entry.getKey(), cachedObjects);
                V clonedValue = ObjectUtils.deepClone(entry.getValue(), cachedObjects);
                newMap.put(clonedKey, clonedValue);
            }
            return newMap;
        }
        catch (Exception e) {
            CloneNotSupportedException ex = new CloneNotSupportedException();
            ex.initCause(e);
            throw ex;
        }
    }

    private static <T> T[] deepCloneArray(T[] srcArray, IdentityHashMap<Object, Object> cachedObjects) throws CloneNotSupportedException {
        if (srcArray == null) {
            return null;
        }
        try {
            Object[] newArray = (Object[])Array.newInstance(srcArray.getClass().getComponentType(), srcArray.length);
            for (int i = 0; i < srcArray.length; ++i) {
                T element = srcArray[i];
                if (element == null) continue;
                newArray[i] = ObjectUtils.deepClone(element, cachedObjects);
            }
            return newArray;
        }
        catch (Exception e) {
            CloneNotSupportedException ex = new CloneNotSupportedException();
            ex.initCause(e);
            throw ex;
        }
    }

    private static <T> T deepClone(T srcObj, IdentityHashMap<Object, Object> cachedObjects) throws CloneNotSupportedException {
        if (srcObj == null) {
            return null;
        }
        if (cachedObjects.containsKey(srcObj)) {
            return (T)cachedObjects.get(srcObj);
        }
        if (ObjectUtils.isImmutable(srcObj.getClass())) {
            return srcObj;
        }
        Object[] clonedObj = null;
        if (srcObj instanceof Collection) {
            clonedObj = ObjectUtils.deepCloneCollection((Collection)srcObj, cachedObjects);
            cachedObjects.put(srcObj, clonedObj);
            return (T)clonedObj;
        }
        if (srcObj instanceof Map) {
            clonedObj = ObjectUtils.deepCloneMap((Map)srcObj, cachedObjects);
            cachedObjects.put(srcObj, clonedObj);
            return (T)clonedObj;
        }
        Class<?> srcObjClass = srcObj.getClass();
        if (srcObjClass.isArray()) {
            clonedObj = ObjectUtils.deepCloneArray((Object[])srcObj, cachedObjects);
            cachedObjects.put(srcObj, clonedObj);
            return (T)clonedObj;
        }
        try {
            Class<?> cloneObjClass;
            clonedObj = ObjectUtils.shallowClone(srcObj);
            cachedObjects.put(srcObj, clonedObj);
            for (Class<?> c = cloneObjClass = clonedObj.getClass(); c != null; c = c.getSuperclass()) {
                Field[] fields;
                for (Field field : fields = c.getDeclaredFields()) {
                    Object clonedFieldValue;
                    Class<?> fieldType;
                    if (Modifier.isStatic(field.getModifiers()) || ObjectUtils.isImmutable(fieldType = field.getType())) continue;
                    if (!field.isAccessible()) {
                        field.setAccessible(true);
                    }
                    if ((clonedFieldValue = field.get(clonedObj)) == null) continue;
                    try {
                        Object srcFieldValue = field.get(srcObj);
                        if (srcFieldValue != clonedFieldValue) {
                            continue;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        clonedFieldValue = ObjectUtils.deepClone(clonedFieldValue, cachedObjects);
                        field.set(clonedObj, clonedFieldValue);
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {
                        // empty catch block
                    }
                }
            }
            return (T)clonedObj;
        }
        catch (Exception e) {
            CloneNotSupportedException cnse = new CloneNotSupportedException();
            cnse.initCause(e);
            throw cnse;
        }
    }

    public static boolean isImmutable(Class<?> clazz) {
        return clazz.isPrimitive() || clazz.isEnum() || String.class.equals(clazz) || Number.class.isAssignableFrom(clazz) || Date.class.equals(clazz);
    }

    public static void main(String[] args) {
    }
}

