/*
 * Decompiled with CFR 0.152.
 */
package com.onaro.commons.util;

import java.lang.ref.SoftReference;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public final class SoftHashMap<K, V>
extends AbstractMap<K, V> {
    private static final int DEFAULT_INITIAL_CAPACITY = 128;
    private final HashMap<K, SoftReference<V>> map;

    public SoftHashMap() {
        this(128);
    }

    public SoftHashMap(int initialCapacity) {
        this.map = new LinkedHashMap<K, SoftReference<V>>(initialCapacity, 2.0f, true){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, SoftReference<V>> eldest) {
                SoftReference ref = eldest.getValue();
                if (ref == null) {
                    return false;
                }
                return ref.get() == null;
            }
        };
    }

    public SoftHashMap(Map<? extends K, ? extends V> t) {
        this(t.size());
        this.putAll(t);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        if (!this.map.containsKey(key)) {
            return false;
        }
        SoftReference<V> ref = this.map.get(key);
        if (ref == null) {
            return true;
        }
        V value = ref.get();
        if (value == null) {
            this.remove(key);
        }
        return value != null;
    }

    @Override
    public V get(Object key) {
        SoftReference<V> ref = this.map.get(key);
        if (ref == null) {
            return null;
        }
        V value = ref.get();
        if (value == null) {
            this.map.remove(key);
        }
        return value;
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public V put(K key, V value) {
        SoftReference<V> newRef = value != null ? new SoftReference<V>(value) : null;
        SoftReference<V> oldRef = this.map.put(key, newRef);
        if (oldRef == null) {
            return null;
        }
        V oldValue = oldRef.get();
        return oldValue;
    }

    @Override
    public V remove(Object key) {
        SoftReference<V> oldRef = this.map.remove(key);
        if (oldRef == null) {
            return null;
        }
        V oldValue = oldRef.get();
        return oldValue;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            return this.map.containsValue(null);
        }
        for (SoftReference<V> ref : this.map.values()) {
            V refValue;
            if (ref == null || (refValue = ref.get()) == null || !value.equals(refValue)) continue;
            return true;
        }
        return false;
    }
}

