/*
 * Decompiled with CFR 0.152.
 */
package com.onaro.commons.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public abstract class TreeMapOfCollections<K, V, C extends Collection<V>>
extends TreeMap<K, C> {
    private static final long serialVersionUID = 1L;
    private boolean returnEmptyCollectionWhenNull;

    protected TreeMapOfCollections(boolean returnEmptyCollectionWhenNull) {
        this.returnEmptyCollectionWhenNull = returnEmptyCollectionWhenNull;
    }

    public boolean contains(K key, V value) {
        Object collection = this.get(key);
        return collection != null && collection.contains(value);
    }

    public boolean add(K key, V value) {
        Collection<Object> collection = (Collection)super.get(key);
        if (collection == null) {
            collection = this.newCollection();
            this.put(key, collection);
        }
        return collection.add(value);
    }

    public void add(TreeMapOfCollections<K, V, C> other) {
        for (Map.Entry entry : other.entrySet()) {
            this.add(entry.getKey(), (Collection)entry.getValue());
        }
    }

    public boolean add(K key, Collection<V> values) {
        Collection<Object> collection = (Collection)super.get(key);
        if (collection == null) {
            collection = this.newCollection();
            this.put(key, collection);
        }
        return collection.addAll(values);
    }

    @Override
    public C get(Object key) {
        Collection rv = (Collection)super.get(key);
        return (C)(rv == null && this.returnEmptyCollectionWhenNull ? this.emptyCollection() : rv);
    }

    public Set<V> getValuesSet() {
        HashSet set = new HashSet();
        for (Collection values : this.values()) {
            set.addAll(values);
        }
        return set;
    }

    protected abstract C newCollection();

    protected abstract C emptyCollection();

    @Override
    public boolean remove(Object key, Object value) {
        boolean changed = false;
        Collection collection = (Collection)super.get(key);
        if (collection != null) {
            changed = collection.remove(value);
            if (collection.isEmpty()) {
                this.remove(key);
            }
        }
        return changed;
    }
}

